/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IConfirmDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionGroup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DestroySessionHandler
extends BaseControlViewHandler {
    private List<TraceSessionComponent> fSessions = new ArrayList<TraceSessionComponent>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IConfirmDialog dialog = TraceControlDialogFactory.getInstance().getConfirmDialog();
        if (!dialog.openConfirm(window.getShell(), Messages.TraceControl_DestroyConfirmationTitle, Messages.TraceControl_DestroyConfirmationMessage)) {
            return null;
        }
        Job job = new Job(Messages.TraceControl_DestroySessionJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TraceSessionComponent[] sessions = DestroySessionHandler.this.fSessions.toArray(new TraceSessionComponent[DestroySessionHandler.this.fSessions.size()]);
                    int i = 0;
                    while (i < sessions.length) {
                        TraceSessionComponent session = sessions[i];
                        TraceSessionGroup sessionGroup = (TraceSessionGroup)session.getParent();
                        sessionGroup.destroySession(session, monitor);
                        ++i;
                    }
                }
                catch (ExecutionException e) {
                    return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_DestroySessionFailure, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        this.fSessions.clear();
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent session;
                if (!(element instanceof TraceSessionComponent) || (session = (TraceSessionComponent)element).getSessionState() != TraceSessionState.INACTIVE || session.isDestroyed()) continue;
                this.fSessions.add((TraceSessionComponent)element);
            }
        }
        return !this.fSessions.isEmpty();
    }
}

