/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.LogLevelType;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseEnableEventHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.ChannelCommandParameter;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceChannelComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceDomainComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class EnableEventOnChannelHandler
extends BaseEnableEventHandler {
    @Override
    public void enableEvents(CommandParameter param, List<String> eventNames, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof ChannelCommandParameter) {
            ((ChannelCommandParameter)param).getChannel().enableEvents(eventNames, monitor);
        }
    }

    @Override
    public void enableSyscalls(CommandParameter param, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof ChannelCommandParameter) {
            ((ChannelCommandParameter)param).getChannel().enableSyscalls(monitor);
        }
    }

    @Override
    public void enableProbe(CommandParameter param, String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof ChannelCommandParameter) {
            ((ChannelCommandParameter)param).getChannel().enableProbe(eventName, isFunction, probe, monitor);
        }
    }

    @Override
    public void enableLogLevel(CommandParameter param, String eventName, LogLevelType logLevelType, TraceLogLevel level, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof ChannelCommandParameter) {
            ((ChannelCommandParameter)param).getChannel().enableLogLevel(eventName, logLevelType, level, monitor);
        }
    }

    @Override
    public TraceDomainComponent getDomain(CommandParameter param) {
        if (param instanceof ChannelCommandParameter) {
            return (TraceDomainComponent)((ChannelCommandParameter)param).getChannel().getParent();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceChannelComponent channel = null;
        TraceSessionComponent session = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceChannelComponent tmpChannel;
                if (!(element instanceof TraceChannelComponent) || (session = (tmpChannel = (TraceChannelComponent)element).getSession()).isDestroyed()) continue;
                channel = tmpChannel;
            }
        }
        boolean isEnabled = channel != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new ChannelCommandParameter(session, channel);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

