/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TargetNodeState;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceProviderGroup;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionGroup;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.property.TargetNodePropertySource;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.IRemoteSystemProxy;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.RemoteSystemProxy;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.ILttngControlService;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.LTTngControlServiceFactory;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSECallback;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class TargetNodeComponent
extends TraceControlComponent
implements ICommunicationsListener {
    public static final String TARGET_NODE_CONNECTED_ICON_FILE = "icons/obj16/target_connected.gif";
    public static final String TARGET_NODE_DISCONNECTED_ICON_FILE = "icons/obj16/target_disconnected.gif";
    private TargetNodeState fState = TargetNodeState.DISCONNECTED;
    private Image fDisconnectedImage = null;
    private IHost fHost = null;
    private IRemoteSystemProxy fRemoteProxy = null;
    private ILttngControlService fService = null;
    private ICommandShell fShell = null;

    public TargetNodeComponent(String name, ITraceControlComponent parent, IHost host, IRemoteSystemProxy proxy) {
        super(name, parent);
        this.setImage(TARGET_NODE_CONNECTED_ICON_FILE);
        this.fDisconnectedImage = Activator.getDefault().loadIcon(TARGET_NODE_DISCONNECTED_ICON_FILE);
        this.fHost = host;
        this.fRemoteProxy = proxy;
        this.setToolTip(this.fHost.getHostName());
    }

    public TargetNodeComponent(String name, ITraceControlComponent parent, IHost host) {
        this(name, parent, host, new RemoteSystemProxy(host));
    }

    @Override
    public Image getImage() {
        if (this.fState == TargetNodeState.CONNECTED) {
            return super.getImage();
        }
        return this.fDisconnectedImage;
    }

    @Override
    public TargetNodeState getTargetNodeState() {
        return this.fState;
    }

    @Override
    public void setTargetNodeState(TargetNodeState state) {
        this.fState = state;
        this.fireComponentChanged(this);
    }

    @Override
    public ILttngControlService getControlService() {
        return this.fService;
    }

    @Override
    public void setControlService(ILttngControlService service) {
        this.fService = service;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new TargetNodePropertySource(this);
        }
        return null;
    }

    public String getHostName() {
        return this.fHost.getHostName();
    }

    public IRemoteSystemProxy getRemoteSystemProxy() {
        return this.fRemoteProxy;
    }

    public TraceSessionComponent[] getSessions() {
        List<ITraceControlComponent> compenents = this.getChildren(TraceSessionGroup.class);
        if (compenents.size() > 0) {
            TraceSessionGroup group = (TraceSessionGroup)compenents.get(0);
            List<ITraceControlComponent> sessions = group.getChildren(TraceSessionComponent.class);
            return sessions.toArray(new TraceSessionComponent[sessions.size()]);
        }
        return new TraceSessionComponent[0];
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        if (e.getState() == 4 || e.getState() == 5) {
            this.handleDisconnected();
        }
        if (e.getState() == 2 && this.fState != TargetNodeState.CONNECTING) {
            this.handleConnected();
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    @Override
    public void dispose() {
        this.fRemoteProxy.removeCommunicationListener(this);
    }

    public void connect() {
        if (this.fState == TargetNodeState.DISCONNECTED) {
            try {
                this.setTargetNodeState(TargetNodeState.CONNECTING);
                this.fRemoteProxy.connect(new IRSECallback(){

                    public void done(IStatus status, Object result) {
                        if (status.isOK()) {
                            TargetNodeComponent.this.handleConnected();
                        } else {
                            TargetNodeComponent.this.handleDisconnected();
                        }
                    }
                });
            }
            catch (Exception e) {
                this.setTargetNodeState(TargetNodeState.DISCONNECTED);
                Activator.getDefault().logError(String.valueOf(Messages.TraceControl_ConnectionFailure) + " (" + this.getName() + "). \n", e);
            }
        }
    }

    public void disconnect() {
        if (this.fState == TargetNodeState.CONNECTED) {
            try {
                try {
                    this.setTargetNodeState(TargetNodeState.DISCONNECTING);
                    this.fRemoteProxy.disconnect();
                }
                catch (Exception e) {
                    Activator.getDefault().logError(String.valueOf(Messages.TraceControl_DisconnectionFailure) + " (" + this.getName() + "). \n", e);
                    this.handleDisconnected();
                }
            }
            finally {
                this.handleDisconnected();
            }
        }
    }

    public void getConfigurationFromNode() {
        Job job = new Job(Messages.TraceControl_RetrieveNodeConfigurationJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TraceProviderGroup providerGroup = new TraceProviderGroup(Messages.TraceControl_ProviderDisplayName, TargetNodeComponent.this);
                    TargetNodeComponent.this.addChild(providerGroup);
                    providerGroup.getProviderFromNode(monitor);
                    TraceSessionGroup sessionGroup = new TraceSessionGroup(Messages.TraceControl_AllSessionsDisplayName, TargetNodeComponent.this);
                    TargetNodeComponent.this.addChild(sessionGroup);
                    sessionGroup.getSessionsFromNode(monitor);
                }
                catch (ExecutionException e) {
                    TargetNodeComponent.this.removeAllChildren();
                    return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_ListSessionFailure, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void refresh() {
        this.removeAllChildren();
        this.getConfigurationFromNode();
    }

    public void deregister() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.deleteHost(this.fHost);
    }

    private ILttngControlService createControlService() throws ExecutionException {
        if (this.fShell == null) {
            this.fShell = this.fRemoteProxy.createCommandShell();
            this.fRemoteProxy.addCommunicationListener(this);
        }
        this.fService = LTTngControlServiceFactory.getInstance().getLttngControlService(this.fShell);
        return this.fService;
    }

    private void handleConnected() {
        this.setTargetNodeState(TargetNodeState.CONNECTED);
        try {
            this.createControlService();
            this.getConfigurationFromNode();
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError(String.valueOf(Messages.TraceControl_ListSessionFailure) + " (" + this.getName() + "). \n", e);
        }
    }

    private void handleDisconnected() {
        this.removeAllChildren();
        this.setTargetNodeState(TargetNodeState.DISCONNECTED);
        this.fShell = null;
        this.fService = null;
    }
}

