/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TargetNodeState;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponentChangedListener;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.ILttngControlService;
import org.eclipse.swt.graphics.Image;

public class TraceControlComponent
implements ITraceControlComponent {
    private String fName = "";
    private Image fImage = null;
    private String fToolTip = null;
    private ITraceControlComponent fParent = null;
    private List<ITraceControlComponent> fChildren = new ArrayList<ITraceControlComponent>();
    private ListenerList fListeners = new ListenerList();

    public TraceControlComponent(String name) {
        this(name, null);
    }

    public TraceControlComponent(String name, ITraceControlComponent parent) {
        this.fName = name;
        this.fParent = parent;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public Image getImage() {
        return this.fImage;
    }

    @Override
    public void setImage(String path) {
        this.fImage = Activator.getDefault().loadIcon(path);
    }

    @Override
    public void setImage(Image image) {
        this.fImage = image;
    }

    @Override
    public String getToolTip() {
        return this.fToolTip;
    }

    @Override
    public void setToolTip(String toolTip) {
        this.fToolTip = toolTip;
    }

    @Override
    public TargetNodeState getTargetNodeState() {
        if (this.getParent() != null) {
            return this.getParent().getTargetNodeState();
        }
        return TargetNodeState.DISCONNECTED;
    }

    @Override
    public void setTargetNodeState(TargetNodeState state) {
        if (this.getParent() != null) {
            this.getParent().setTargetNodeState(state);
        }
    }

    @Override
    public ITraceControlComponent getParent() {
        return this.fParent;
    }

    @Override
    public void setParent(ITraceControlComponent parent) {
        this.fParent = parent;
    }

    @Override
    public ITraceControlComponent[] getChildren() {
        return this.fChildren.toArray(new ITraceControlComponent[this.fChildren.size()]);
    }

    @Override
    public void setChildren(List<ITraceControlComponent> children) {
        for (ITraceControlComponent traceControlComponent : children) {
            this.fChildren.add(traceControlComponent);
            this.fireComponentChanged(this);
        }
    }

    @Override
    public ITraceControlComponent getChild(String name) {
        ITraceControlComponent child = null;
        int i = 0;
        while (i < this.fChildren.size()) {
            if (this.fChildren.get(i).getName().equals(name)) {
                child = this.fChildren.get(i);
                break;
            }
            ++i;
        }
        return child;
    }

    @Override
    public List<ITraceControlComponent> getChildren(Class<? extends ITraceControlComponent> clazz) {
        ArrayList<ITraceControlComponent> list = new ArrayList<ITraceControlComponent>();
        for (ITraceControlComponent child : this.fChildren) {
            if (child.getClass() != clazz) continue;
            list.add(child);
        }
        return list;
    }

    @Override
    public ILttngControlService getControlService() {
        if (this.getParent() != null) {
            return this.getParent().getControlService();
        }
        return null;
    }

    @Override
    public void setControlService(ILttngControlService service) {
        if (this.getParent() != null) {
            this.getParent().setControlService(service);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addChild(ITraceControlComponent component) {
        if (component != null) {
            this.fChildren.add(component);
        }
        this.fireComponentAdded(this, component);
    }

    @Override
    public void removeChild(ITraceControlComponent component) {
        if (component != null) {
            this.fChildren.remove(component);
            component.dispose();
        }
        this.fireComponentRemoved(this, component);
    }

    @Override
    public void removeAllChildren() {
        for (ITraceControlComponent child : this.fChildren) {
            child.removeAllChildren();
        }
        this.fChildren.clear();
    }

    @Override
    public boolean containsChild(String name) {
        boolean retValue = false;
        int i = 0;
        while (i < this.fChildren.size()) {
            if (this.fChildren.get(i).getName().equals(name)) {
                retValue = true;
                break;
            }
            ++i;
        }
        return retValue;
    }

    @Override
    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    @Override
    public void addComponentListener(ITraceControlComponentChangedListener listener) {
        if (this.fParent != null) {
            this.fParent.addComponentListener(listener);
        } else {
            this.fListeners.add((Object)listener);
        }
    }

    @Override
    public void removeComponentListener(ITraceControlComponentChangedListener listener) {
        if (this.fParent != null) {
            this.fParent.removeComponentListener(listener);
        } else {
            this.fListeners.remove((Object)listener);
        }
    }

    @Override
    public void fireComponentAdded(ITraceControlComponent parent, ITraceControlComponent component) {
        if (component == null) {
            return;
        }
        if (this.fParent != null) {
            this.fParent.fireComponentAdded(parent, component);
        } else {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ITraceControlComponentChangedListener listener = (ITraceControlComponentChangedListener)listeners[i];
                listener.componentAdded(parent, component);
                ++i;
            }
        }
    }

    @Override
    public void fireComponentRemoved(ITraceControlComponent parent, ITraceControlComponent component) {
        if (component == null) {
            return;
        }
        if (this.fParent != null) {
            this.fParent.fireComponentRemoved(parent, component);
        } else {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ITraceControlComponentChangedListener listener = (ITraceControlComponentChangedListener)listeners[i];
                listener.componentRemoved(parent, component);
                ++i;
            }
        }
    }

    @Override
    public void fireComponentChanged(ITraceControlComponent component) {
        if (component == null) {
            return;
        }
        if (this.fParent != null) {
            this.fParent.fireComponentChanged(component);
        } else {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ITraceControlComponentChangedListener listener = (ITraceControlComponentChangedListener)listeners[i];
                listener.componentChanged(component);
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

