/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileDownloadHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileHyperlink;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.ui.part.FileEditorInput;

public class SourcesFileHyperlinkDetector
extends AbstractHyperlinkDetector {
    SpecfileEditor editor;
    private static final String PATCH_IDENTIFIER = "Patch";
    private static final String SOURCE_IDENTIFIER = "Source";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        if (this.editor == null) {
            this.editor = (SpecfileEditor)((Object)this.getAdapter(SpecfileEditor.class));
            if (this.editor == null) {
                return null;
            }
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (this.editor.getEditorInput() instanceof FileEditorInput) {
            IFile original = ((FileEditorInput)this.editor.getEditorInput()).getFile();
            if (line.startsWith(SOURCE_IDENTIFIER) || line.startsWith(PATCH_IDENTIFIER)) {
                int delimiterIndex = line.indexOf(58) + 1;
                String fileName = line.substring(delimiterIndex).trim();
                if (region.getOffset() > lineInfo.getOffset() + line.indexOf(fileName)) {
                    Region fileNameRegion = new Region(lineInfo.getOffset() + line.indexOf(fileName), fileName.length());
                    return new IHyperlink[]{new SourcesFileHyperlink(original, UiUtils.resolveDefines(this.editor.getSpecfile(), fileName), (IRegion)fileNameRegion), new SourcesFileDownloadHyperlink(original, UiUtils.resolveDefines(this.editor.getSpecfile(), fileName), (IRegion)fileNameRegion)};
                }
            }
        }
        return null;
    }

    public void setEditor(SpecfileEditor editor) {
        this.editor = editor;
    }
}

