/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class TmfCheckpoint
implements ITmfCheckpoint,
Cloneable {
    private ITmfContext fContext;
    private ITmfTimestamp fTimestamp;

    private TmfCheckpoint() {
    }

    public TmfCheckpoint(ITmfTimestamp timestamp, ITmfContext context) {
        this.fTimestamp = timestamp;
        this.fContext = context;
    }

    public TmfCheckpoint(TmfCheckpoint other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fTimestamp = other.fTimestamp;
        this.fContext = other.fContext;
    }

    @Override
    public TmfCheckpoint clone() {
        TmfCheckpoint clone = null;
        try {
            clone = (TmfCheckpoint)super.clone();
            clone.fContext = this.fContext != null ? this.fContext.clone() : null;
            clone.fTimestamp = this.fTimestamp != null ? this.fTimestamp.clone() : null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public ITmfContext getContext() {
        return this.fContext;
    }

    @Override
    public ITmfLocation<? extends Comparable<?>> getLocation() {
        return this.fContext.getLocation();
    }

    @Override
    public int compareTo(ITmfCheckpoint other) {
        if (this.fTimestamp == null || other.getTimestamp() == null) {
            Comparable<?> location1 = this.getLocation().getLocation();
            Comparable<?> location2 = other.getLocation().getLocation();
            return location1.compareTo(location2);
        }
        return this.fTimestamp.compareTo(other.getTimestamp(), false);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fContext == null ? 0 : this.fContext.hashCode());
        result = 31 * result + (this.fTimestamp == null ? 0 : this.fTimestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfCheckpoint)) {
            return false;
        }
        TmfCheckpoint other = (TmfCheckpoint)obj;
        if (this.fContext == null ? other.fContext != null : !this.fContext.equals(other.fContext)) {
            return false;
        }
        return !(this.fTimestamp == null ? other.fTimestamp != null : !this.fTimestamp.equals(other.fTimestamp));
    }

    public String toString() {
        return "TmfCheckpoint [fContext=" + this.fContext + ", fTimestamp=" + this.fTimestamp + "]";
    }
}

