/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IReconcilingParticipant;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IWorkingCopyManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MakefileContentOutlinePage;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MakefileEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class MakefileReconcilingStrategy
implements IReconcilingStrategy {
    private int fLastRegionOffset;
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private MakefileContentOutlinePage fOutliner;
    private IReconcilingParticipant fMakefileReconcilingParticipant;

    public MakefileReconcilingStrategy(MakefileEditor editor) {
        this.fOutliner = editor.getOutlinePage();
        this.fLastRegionOffset = Integer.MAX_VALUE;
        this.fEditor = editor;
        this.fManager = AutomakeEditorFactory.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider();
        this.fMakefileReconcilingParticipant = (IReconcilingParticipant)this.fEditor;
    }

    public void setDocument(IDocument document) {
    }

    public void reconcile(IRegion region) {
        if (region.getOffset() <= this.fLastRegionOffset) {
            this.reconcile();
        }
        this.fLastRegionOffset = region.getOffset();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
    }

    private void reconcile() {
        block6: {
            try {
                IMakefile makefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
                if (makefile == null) break block6;
                String content = this.fDocumentProvider.getDocument((Object)this.fEditor.getEditorInput()).get();
                StringReader reader = new StringReader(content);
                try {
                    makefile.parse(makefile.getFileURI(), (Reader)reader);
                }
                catch (IOException iOException) {}
                this.fOutliner.update();
            }
            finally {
                if (this.fMakefileReconcilingParticipant != null) {
                    this.fMakefileReconcilingParticipant.reconciled();
                }
            }
        }
    }
}

