/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.widgets;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;

public class Criteria {
    protected boolean lifeLineSelected = false;
    protected boolean syncMessageSelected = false;
    protected boolean syncMessageReturnSelected = false;
    protected boolean asyncMessageSelected = false;
    protected boolean asyncMessageReturnSelected = false;
    private boolean caseSenstiveSelected = false;
    protected boolean stopSelected = false;
    private String expression = null;
    private Pattern pattern = null;

    public Criteria() {
    }

    public Criteria(Criteria other) {
        this.lifeLineSelected = other.lifeLineSelected;
        this.syncMessageSelected = other.syncMessageSelected;
        this.syncMessageReturnSelected = other.syncMessageReturnSelected;
        this.asyncMessageSelected = other.asyncMessageSelected;
        this.asyncMessageReturnSelected = other.asyncMessageReturnSelected;
        this.caseSenstiveSelected = other.caseSenstiveSelected;
        this.stopSelected = other.stopSelected;
        this.setExpression(other.expression);
    }

    public boolean isAsyncMessageReturnSelected() {
        return this.asyncMessageReturnSelected;
    }

    public boolean isAsyncMessageSelected() {
        return this.asyncMessageSelected;
    }

    public String getExpression() {
        return this.expression;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isLifeLineSelected() {
        return this.lifeLineSelected;
    }

    public boolean isStopSelected() {
        return this.stopSelected;
    }

    public boolean isSyncMessageReturnSelected() {
        return this.syncMessageReturnSelected;
    }

    public boolean isSyncMessageSelected() {
        return this.syncMessageSelected;
    }

    public void setAsyncMessageReturnSelected(boolean b) {
        this.asyncMessageReturnSelected = b;
    }

    public void setAsyncMessageSelected(boolean b) {
        this.asyncMessageSelected = b;
    }

    public void setExpression(String string) {
        block5: {
            this.expression = string;
            if (this.expression != null) {
                try {
                    if (this.caseSenstiveSelected) {
                        this.pattern = Pattern.compile(string);
                        break block5;
                    }
                    this.pattern = Pattern.compile(string, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.pattern = null;
                }
            } else {
                this.pattern = null;
            }
        }
    }

    public void setLifeLineSelected(boolean b) {
        this.lifeLineSelected = b;
    }

    public void setStopSelected(boolean b) {
        this.stopSelected = b;
    }

    public void setSyncMessageReturnSelected(boolean b) {
        this.syncMessageReturnSelected = b;
    }

    public void setSyncMessageSelected(boolean b) {
        this.syncMessageSelected = b;
    }

    public boolean isCaseSenstiveSelected() {
        return this.caseSenstiveSelected;
    }

    public void setCaseSenstiveSelected(boolean b) {
        this.caseSenstiveSelected = b;
        this.setExpression(this.expression);
    }

    public boolean compareTo(Criteria to) {
        boolean retVal = true;
        if (this.getExpression() != null) {
            retVal = this.getExpression().equals(to.getExpression());
        } else if (to.getExpression() != null) {
            retVal = to.getExpression().equals(this.getExpression());
        }
        return retVal && this.isCaseSenstiveSelected() == to.isCaseSenstiveSelected() && this.isAsyncMessageReturnSelected() == to.isAsyncMessageReturnSelected() && this.isAsyncMessageSelected() == to.isAsyncMessageSelected() && this.isLifeLineSelected() == to.isLifeLineSelected() && this.isStopSelected() == to.isStopSelected() && this.isSyncMessageReturnSelected() == to.isSyncMessageReturnSelected() && this.isSyncMessageSelected() == to.isSyncMessageSelected();
    }

    public void save(DialogSettings settings) {
        settings.put("expression", this.getExpression());
        settings.put("isCaseSenstiveSelected", this.isCaseSenstiveSelected());
        settings.put("isAsyncMessageReturnSelected", this.isAsyncMessageReturnSelected());
        settings.put("isAsyncMessageSelected", this.isAsyncMessageSelected());
        settings.put("isLifeLineSelected", this.isLifeLineSelected());
        settings.put("isStopSelected", this.isStopSelected());
        settings.put("isSyncMessageReturnSelected", this.isSyncMessageReturnSelected());
        settings.put("isSyncMessageSelected", this.isSyncMessageSelected());
    }

    public void load(DialogSettings settings) {
        this.setExpression(settings.get("expression"));
        this.setCaseSenstiveSelected(settings.getBoolean("isCaseSenstiveSelected"));
        this.setAsyncMessageReturnSelected(settings.getBoolean("isAsyncMessageReturnSelected"));
        this.setAsyncMessageSelected(settings.getBoolean("isAsyncMessageSelected"));
        this.setLifeLineSelected(settings.getBoolean("isLifeLineSelected"));
        this.setStopSelected(settings.getBoolean("isStopSelected"));
        this.setSyncMessageReturnSelected(settings.getBoolean("isSyncMessageReturnSelected"));
        this.setSyncMessageSelected(settings.getBoolean("isSyncMessageSelected"));
    }

    public String getGraphNodeSummary(ISDFilterProvider provider, String loaderClassName) {
        ArrayList<String> list = new ArrayList<String>();
        if (provider != null) {
            if (this.isLifeLineSelected()) {
                list.add(provider.getNodeName(0, loaderClassName));
            }
            if (this.isSyncMessageSelected()) {
                list.add(provider.getNodeName(1, loaderClassName));
            }
            if (this.isSyncMessageReturnSelected()) {
                list.add(provider.getNodeName(2, loaderClassName));
            }
            if (this.isAsyncMessageSelected()) {
                list.add(provider.getNodeName(3, loaderClassName));
            }
            if (this.isAsyncMessageReturnSelected()) {
                list.add(provider.getNodeName(4, loaderClassName));
            }
            if (this.isStopSelected()) {
                list.add(provider.getNodeName(5, loaderClassName));
            }
        } else {
            if (this.isLifeLineSelected()) {
                list.add(SDMessages._28);
            }
            if (this.isSyncMessageSelected()) {
                list.add(SDMessages._30);
            }
            if (this.isSyncMessageReturnSelected()) {
                list.add(SDMessages._31);
            }
            if (this.isAsyncMessageSelected()) {
                list.add(SDMessages._32);
            }
            if (this.isAsyncMessageReturnSelected()) {
                list.add(SDMessages._33);
            }
            if (this.isStopSelected()) {
                list.add(SDMessages._29);
            }
        }
        String ret = "";
        String prefix = "[";
        for (String s : list) {
            ret = String.valueOf(ret) + prefix + s;
            prefix = " " + SDMessages._34 + " ";
        }
        ret = String.valueOf(ret) + "]";
        return ret;
    }

    public boolean matches(String stringToMatch) {
        if (this.pattern == null) {
            return false;
        }
        return this.pattern.matcher(stringToMatch).matches();
    }
}

