/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.scm.ScmTag;
import org.eclipse.m2e.scm.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class ScmUrl {
    private final String scmUrl;
    private final String scmParentUrl;
    private final ScmTag tag;

    public ScmUrl(String scmUrl) {
        this(scmUrl, null);
    }

    public ScmUrl(String scmUrl, String scmParentUrl) {
        this(scmUrl, scmParentUrl, null);
    }

    public ScmUrl(String scmUrl, String scmParentUrl, ScmTag tag) {
        this.scmUrl = scmUrl;
        this.scmParentUrl = scmParentUrl;
        this.tag = tag;
    }

    public String getUrl() {
        return this.scmUrl;
    }

    public String getParentUrl() {
        return this.scmParentUrl;
    }

    public ScmTag getTag() {
        return this.tag;
    }

    public String getProviderUrl() {
        try {
            String type = ScmUrl.getType(this.scmUrl);
            return this.scmUrl.substring(type.length() + 5);
        }
        catch (CoreException ex) {
            return null;
        }
    }

    public static synchronized String getType(String url) throws CoreException {
        if (!url.startsWith("scm:")) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.ScmUrl_error, (Object)url)));
        }
        int n = url.indexOf(":", 4);
        if (n == -1) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.ScmUrl_error, (Object)url)));
        }
        return url.substring(4, n);
    }
}

