/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.filter;

import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.utility.StringMatcher;
import org.eclipse.team.svn.ui.history.filter.ILogEntryFilter;

public class CommentLogEntryFilter
implements ILogEntryFilter {
    protected String commentToAccept;

    public CommentLogEntryFilter() {
        this(null);
    }

    public CommentLogEntryFilter(String commentToAccept) {
        this.commentToAccept = commentToAccept;
    }

    @Override
    public boolean accept(SVNLogEntry logEntry) {
        if (this.commentToAccept == null) {
            return true;
        }
        StringMatcher matcher = new StringMatcher(this.commentToAccept);
        String comment = logEntry.message == null ? "" : logEntry.message;
        return matcher.match(comment);
    }

    public void setCommentToAccept(String commentToAccept) {
        this.commentToAccept = commentToAccept;
    }

    public String getCommentToAccept() {
        return this.commentToAccept;
    }
}

