/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.model;

import java.util.ArrayList;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.IRepositoryContentFilter;
import org.eclipse.team.svn.ui.repository.model.IResourceTreeNode;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class RepositoryContentProvider
extends WorkbenchContentProvider {
    protected RepositoryTreeViewer repositoryTree;
    protected IRepositoryContentFilter filter;

    public RepositoryContentProvider(RepositoryTreeViewer repositoryTree) {
        this.repositoryTree = repositoryTree;
    }

    public IRepositoryContentFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IRepositoryContentFilter filter) {
        this.filter = filter;
    }

    public boolean hasChildren(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter instanceof IParentTreeNode) {
            return ((IParentTreeNode)adapter).hasChildren();
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        IWorkbenchAdapter adapter = this.getAdapter(parentElement);
        if (adapter instanceof IParentTreeNode) {
            if (adapter instanceof IResourceTreeNode) {
                ((IResourceTreeNode)adapter).setViewer(this.repositoryTree);
            }
            ArrayList<Object> filtered = new ArrayList<Object>();
            Object[] children = adapter.getChildren(parentElement);
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.filter == null || this.filter.accept(child)) {
                        if (child instanceof IResourceTreeNode) {
                            ((IResourceTreeNode)child).setViewer(this.repositoryTree);
                        }
                        filtered.add(child);
                    }
                    ++n2;
                }
            }
            return filtered.toArray();
        }
        return new Object[0];
    }
}

