/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.selectresource;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.team.svn.ui.wizard.shareproject.SelectRepositoryLocationPage;
import org.eclipse.ui.PlatformUI;

public class SelectSimpleRepositoryLocationPage
extends AbstractVerifiedWizardPage {
    protected IRepositoryLocation location;
    protected TableViewer repositoriesView;
    protected IRepositoryLocation[] repositories;

    public SelectSimpleRepositoryLocationPage(IRepositoryLocation[] repositories) {
        super(SelectSimpleRepositoryLocationPage.class.getName(), SVNUIMessages.SelectSimpleRepositoryLocationPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.SelectSimpleRepositoryLocationPage_Description);
        this.repositories = repositories;
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label description = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 200;
        data.heightHint = this.convertHeightInCharsToPixels(2);
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.SelectSimpleRepositoryLocationPage_Details);
        this.repositoriesView = SelectRepositoryLocationPage.createRepositoriesListTable(composite, this.repositories);
        this.repositoriesView.addDoubleClickListener(event -> {
            IWizard wizard = this.getWizard();
            IWizardPage nextPage = wizard.getNextPage((IWizardPage)this);
            if (nextPage != null) {
                wizard.getContainer().showPage(nextPage);
            }
        });
        this.repositoriesView.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)this.repositoriesView.getSelection();
            this.location = (IRepositoryLocation)selection.getFirstElement();
            this.setPageComplete(true);
        });
        IStructuredSelection selection = (IStructuredSelection)this.repositoriesView.getSelection();
        this.location = (IRepositoryLocation)selection.getFirstElement();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.selectRepositoryLocationContext");
        return composite;
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.location;
    }
}

