/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.AsynchronousActiveQueue;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.IQueuedElement;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ResourceChangeListener
implements IResourceChangeListener,
ISaveParticipant {
    protected AsynchronousActiveQueue<ResourceChange> refreshQueue = new AsynchronousActiveQueue<ResourceChange>("Operation_ResourcesChanged", (monitor, op, record) -> {
        IResource[] resources = record.resources;
        SVNRemoteStorage.instance().refreshLocalResources(resources, record.depth);
        ResourceStatesChangedEvent pathEvent = new ResourceStatesChangedEvent(FileUtility.getPathNodes(resources), 0, 1);
        SVNRemoteStorage.instance().fireResourceStatesChangedEvent(pathEvent);
        ResourceStatesChangedEvent resourcesEvent = new ResourceStatesChangedEvent(resources, 0, 0);
        SVNRemoteStorage.instance().fireResourceStatesChangedEvent(resourcesEvent);
    }, false);
    public static int INTERESTING_CHANGES = 323584;

    public void resourceChanged(final IResourceChangeEvent event) {
        ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation("Operation_ResourcesChanged", SVNMessages.class){

            @Override
            protected void runImpl(IProgressMonitor monitor) throws Exception {
                HashSet modified = new HashSet();
                int[] depth = new int[1];
                event.getDelta().accept(delta -> {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (!FileUtility.isConnected(resource)) {
                        return false;
                    }
                    IContainer toAdd = null;
                    IResource svnFolder = FileUtility.getSVNFolder(resource);
                    if (svnFolder != null) {
                        toAdd = svnFolder.getParent();
                        return false;
                    }
                    if (resource instanceof IFolder && SVNUtility.isIgnored(resource)) {
                        if (SVNTeamPlugin.instance().isDebugging()) {
                            System.out.println("Ignoring: " + String.valueOf(resource.getLocation()));
                        }
                        return false;
                    }
                    if (delta.getKind() == 1 || delta.getKind() == 2) {
                        toAdd = resource;
                    } else if (delta.getKind() == 4) {
                        int flags = delta.getFlags();
                        if (resource instanceof IContainer && (flags & INTERESTING_CHANGES) != 0 || resource instanceof IFile && (flags & (INTERESTING_CHANGES | 0x100)) != 0) {
                            toAdd = resource;
                        }
                    }
                    if (toAdd != null) {
                        if (SVNUtility.isIgnored((IResource)toAdd)) {
                            if (SVNTeamPlugin.instance().isDebugging()) {
                                System.out.println("Ignoring: " + String.valueOf(toAdd.getLocation()));
                            }
                            return false;
                        }
                        modified.add(toAdd);
                        if (toAdd.getType() != 1) {
                            nArray[0] = 2;
                        }
                    }
                    return true;
                }, 2);
                if (modified.size() > 0) {
                    IResource[] resources = modified.toArray(new IResource[modified.size()]);
                    ResourceChangeListener.this.refreshQueue.push(new ResourceChange(resources, depth[0]));
                }
            }
        });
    }

    public void handleInitialWorkspaceDelta() throws CoreException {
        ISavedState ss = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)SVNTeamPlugin.instance(), (ISaveParticipant)this);
        if (ss != null) {
            ss.processResourceChangeEvents((IResourceChangeListener)this);
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }

    private static class ResourceChange
    implements IQueuedElement<ResourceChange> {
        private IResource[] resources;
        private int depth;

        public ResourceChange(IResource[] resources, int depth) {
            this.resources = resources;
            this.depth = depth;
        }

        @Override
        public boolean canSkip() {
            return true;
        }

        @Override
        public boolean canMerge(ResourceChange d) {
            return this.depth == d.depth;
        }

        @Override
        public ResourceChange merge(ResourceChange d) {
            IResource[] arr = new IResource[this.resources.length + d.resources.length];
            System.arraycopy(this.resources, 0, arr, 0, this.resources.length);
            System.arraycopy(d.resources, 0, arr, this.resources.length, d.resources.length);
            return new ResourceChange(arr, this.depth);
        }

        public int hashCode() {
            return Objects.hash(this.depth, Arrays.hashCode(this.resources));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResourceChange)) {
                return false;
            }
            ResourceChange other = (ResourceChange)obj;
            return this.depth == other.depth && Arrays.equals(this.resources, other.resources);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResourceChange [depth=");
            builder.append(this.depth);
            builder.append(", ");
            builder.append(", size=");
            builder.append(this.resources.length);
            builder.append(", ");
            builder.append("resources=");
            builder.append(Arrays.toString(this.resources));
            builder.append("]");
            return builder.toString();
        }
    }
}

