/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

public class AddToSVNIgnoreOperation
extends AbstractFileOperation {
    protected int ignoreType;
    protected String pattern;

    public AddToSVNIgnoreOperation(File[] files, int ignoreType, String pattern) {
        super("Operation_AddToSVNIgnoreFile", SVNMessages.class, files);
        this.ignoreType = ignoreType;
        this.pattern = pattern;
    }

    public AddToSVNIgnoreOperation(IFileProvider provider, int ignoreType, String pattern) {
        super("Operation_AddToSVNIgnoreFile", SVNMessages.class, provider);
        this.ignoreType = ignoreType;
        this.pattern = pattern;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            File current = files[i];
            this.protectStep(monitor1 -> this.handleResource(current), monitor, files.length);
            ++i;
        }
    }

    protected void handleResource(File current) throws Exception {
        File parent = current.getParentFile();
        if (parent == null) {
            return;
        }
        IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(parent, false);
        IRepositoryLocation location = remote.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            org.eclipse.team.svn.core.operation.local.AddToSVNIgnoreOperation.changeIgnoreProperty(proxy, this.ignoreType, this.pattern, parent.getAbsolutePath(), current.getName());
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

