/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RenameResourceOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String message;
    protected String newName;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public RenameResourceOperation(IRepositoryResource resource, String newName, String message) {
        super("Operation_Rename", SVNMessages.class, new IRepositoryResource[]{resource});
        this.message = message;
        this.newName = newName;
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        String newUrl = resource.getParent().getUrl() + "/" + this.newName;
        ISVNNotificationCallback notify = info -> {
            String[] path = new String[]{newUrl};
            this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
            String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
            this.writeToConsole(1, message);
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.writeToConsole(0, "svn move \"" + resource.getUrl() + "\" \"" + newUrl + "\" -m \"" + this.message + "\"" + ISVNConnector.Options.asCommandLine(32768L) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.moveRemote(new String[]{SVNUtility.encodeURL(resource.getUrl())}, SVNUtility.encodeURL(newUrl), this.message, 32768L, null, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            resource.getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getName(), this.newName});
    }
}

