/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.extension.options;

import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.utility.ILoggedOperationFactory;

public abstract class AbstractOptionProvider
implements IOptionProvider {
    @Override
    public String[] getCoveredProviders() {
        return null;
    }

    @Override
    public ISVNCredentialsPrompt getCredentialsPrompt() {
        return null;
    }

    @Override
    public ILoggedOperationFactory getLoggedOperationFactory() {
        return ILoggedOperationFactory.DEFAULT;
    }

    @Override
    public void addProjectSetCapabilityProcessing(CompositeOperation op) {
    }

    @Override
    public FileModificationValidator getFileModificationValidator() {
        return null;
    }

    @Override
    public SVNProperty[] getAutomaticProperties(String template) {
        return new SVNProperty[0];
    }

    @Override
    public String getResource(String key) {
        return SVNMessages.getErrorString(key);
    }

    @Override
    public boolean is(String key) {
        Object value = this.get(key);
        return value instanceof Boolean && (Boolean)value != false;
    }

    @Override
    public boolean has(String key) {
        return this.get(key) != null;
    }

    @Override
    public String getString(String key) {
        Object value = this.get(key);
        return value instanceof String ? (String)value : null;
    }

    @Override
    public Object get(String key) {
        if ("svnConnectorId".equals(key)) {
            return this.getSVNConnectorId();
        }
        if ("defaultTrunkName".equals(key)) {
            return this.getDefaultTrunkName();
        }
        if ("defaultBranchesName".equals(key)) {
            return this.getDefaultBranchesName();
        }
        if ("defaultTagsName".equals(key)) {
            return this.getDefaultTagsName();
        }
        if ("persistentSSHEnabled".equals(key)) {
            return this.isPersistentSSHEnabled();
        }
        if ("textMIMETypeRequired".equals(key)) {
            return this.isTextMIMETypeRequired();
        }
        if ("svnCacheEnabled".equals(key)) {
            return this.isSVNCacheEnabled();
        }
        if ("automaticProjectShareEnabled".equals(key)) {
            return this.isAutomaticProjectShareEnabled();
        }
        return null;
    }

    protected String getSVNConnectorId() {
        return "org.eclipse.team.svn.connector.svnkit1_10";
    }

    protected String getDefaultTrunkName() {
        return "trunk";
    }

    protected String getDefaultBranchesName() {
        return "branches";
    }

    protected String getDefaultTagsName() {
        return "tags";
    }

    protected boolean isAutomaticProjectShareEnabled() {
        return false;
    }

    protected boolean isSVNCacheEnabled() {
        return true;
    }

    protected boolean isTextMIMETypeRequired() {
        return true;
    }

    protected boolean isPersistentSSHEnabled() {
        return true;
    }

    protected boolean isCommitDerivedEnabled() {
        return false;
    }
}

