/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.file.IFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.AbstractSVNStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNFileStorage
extends AbstractSVNStorage
implements IFileStorage {
    public static final String PREF_REPOSITORIES_NODE = "externalRepositories";
    public static final String PREF_MIGRATE_FROM_AUTH_DB_NODE = "externalMigrateFromAuthorizationDatabase";
    public static final String STATE_INFO_FILE_NAME = ".externalSVNRepositories";
    private static SVNFileStorage instance = new SVNFileStorage();

    public static SVNFileStorage instance() {
        return instance;
    }

    @Override
    public void initialize(Map<String, Object> preferences) throws Exception {
        preferences.put("internal.stateInfoFile", STATE_INFO_FILE_NAME);
        preferences.put("internal.repoNodeName", PREF_REPOSITORIES_NODE);
        preferences.put("internal.authNodeName", PREF_MIGRATE_FROM_AUTH_DB_NODE);
        super.initialize(preferences);
    }

    @Override
    public IRepositoryResource asRepositoryResource(File file, boolean allowsNull) {
        File wcRoot = file;
        SVNEntryInfo info = null;
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            while (info == null) {
                if (wcRoot == null) {
                    if (allowsNull) {
                        return null;
                    }
                    throw new RuntimeException(file.getAbsolutePath() + " is not under version control");
                }
                info = SVNUtility.getSVNInfo(wcRoot, proxy);
                if (info != null) continue;
                wcRoot = wcRoot.getParentFile();
            }
        }
        finally {
            proxy.dispose();
        }
        Object wcUrl = SVNUtility.decodeURL(info.url);
        String rootUrl = SVNUtility.decodeURL(info.reposRootUrl);
        IRepositoryLocation location = this.findLocation((String)wcUrl, rootUrl);
        if (wcRoot != file) {
            wcUrl = (String)wcUrl + file.getAbsolutePath().substring(wcRoot.getAbsolutePath().length());
        }
        return file.isFile() ? location.asRepositoryFile((String)wcUrl, allowsNull) : location.asRepositoryContainer((String)wcUrl, allowsNull);
    }

    protected IRepositoryLocation findLocation(String resourceUrl, String rootUrl) {
        IRepositoryLocation location;
        IRepositoryLocation[] locations;
        IPath url = SVNUtility.createPathForSVNUrl(resourceUrl);
        IRepositoryLocation[] iRepositoryLocationArray = locations = this.getRepositoryLocations();
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            location = iRepositoryLocationArray[n2];
            if (SVNUtility.createPathForSVNUrl(location.getUrl()).isPrefixOf(url)) {
                return location;
            }
            ++n2;
        }
        iRepositoryLocationArray = locations;
        n = locations.length;
        n2 = 0;
        while (n2 < n) {
            location = iRepositoryLocationArray[n2];
            if (location.getRepositoryRootUrl().equals(rootUrl)) {
                return location;
            }
            ++n2;
        }
        location = this.newRepositoryLocation();
        SVNUtility.initializeRepositoryLocation(location, rootUrl);
        this.addRepositoryLocation(location);
        return location;
    }

    private SVNFileStorage() {
    }

    @Override
    protected IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation location, String url, boolean isFile) {
        return location;
    }
}

