/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IResourcePropertyProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SetPropertiesOperation
extends AbstractWorkingCopyOperation {
    protected SVNProperty[] propertyData;
    protected boolean isRecursive;
    protected IResourcePropertyProvider propertyProvider;

    public SetPropertiesOperation(IResource[] resources, String name, byte[] data, boolean isRecursive) {
        this(resources, new SVNProperty[]{new SVNProperty(name, new String(data))}, isRecursive);
    }

    public SetPropertiesOperation(IResource[] resources, SVNProperty[] data, boolean isRecursive) {
        super("Operation_SetProperties", SVNMessages.class, resources);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    public SetPropertiesOperation(IResourceProvider resourceProvider, SVNProperty[] data, boolean isRecursive) {
        super("Operation_SetProperties", SVNMessages.class, resourceProvider);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    public SetPropertiesOperation(IResource[] resources, IResourcePropertyProvider propertyProvider, boolean isRecursive) {
        super("Operation_SetProperties", SVNMessages.class, resources);
        this.propertyProvider = propertyProvider;
        this.isRecursive = isRecursive;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.isRecursive) {
            resources = FileUtility.shrinkChildNodes(resources);
        }
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IResource resource = resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> this.processResource(proxy, resource, monitor1), monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected void processResource(ISVNConnector proxy, IResource resource, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, resource.getFullPath().toString());
        String wcPath = FileUtility.getWorkingCopyPath(resource);
        SVNProperty[] properties = this.getOperableProperties();
        int i = 0;
        while (i < properties.length && !monitor.isCanceled()) {
            SVNProperty current = properties[i];
            this.protectStep(monitor1 -> proxy.setPropertyLocal(new String[]{wcPath}, current, SVNDepth.infinityOrEmpty(this.isRecursive), 0L, null, new SVNProgressMonitor(this, monitor1, null)), monitor, properties.length);
            ++i;
        }
    }

    protected SVNProperty[] getOperableProperties() {
        return this.propertyData == null ? this.propertyProvider.getProperties() : this.propertyData;
    }
}

