/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.resource.events;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.IQueuedElement;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ResourceStatesChangedEvent
implements IQueuedElement<ResourceStatesChangedEvent> {
    public static final int CHANGED_NODES = 0;
    public static final int PATH_NODES = 1;
    public final IResource[] resources;
    public final int depth;
    public final int type;
    private IResource[] fullSet;

    public ResourceStatesChangedEvent(IResource[] resources, int depth, int type) {
        this.resources = resources;
        FileUtility.reorder(resources, true);
        this.depth = depth;
        this.type = type;
        if (this.depth == 0) {
            this.fullSet = this.resources;
        }
    }

    public IResource[] getResourcesRecursivelly() {
        if (this.fullSet == null) {
            try {
                this.fullSet = ResourceStatesChangedEvent.collectResources(this.resources, this.depth);
                FileUtility.reorder(this.fullSet, true);
            }
            catch (Exception exception) {
                this.fullSet = this.resources;
            }
        }
        return this.fullSet;
    }

    public boolean contains(IResource resource) {
        if (this.containsImpl(resource)) {
            return true;
        }
        if (this.depth != 0) {
            if (this.containsImpl((IResource)resource.getParent())) {
                return true;
            }
            if (this.depth != 1) {
                IPath path = resource.getFullPath();
                IResource[] iResourceArray = this.resources;
                int n = this.resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource element = iResourceArray[n2];
                    if (element.getFullPath().isPrefixOf(path)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public static IResource[] collectResources(IResource[] resources, int depth) throws Exception {
        if (depth == 0) {
            return resources;
        }
        HashSet fullList = new HashSet();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            FileUtility.visitNodes(element, resource -> {
                if (FileUtility.isNotSupervised(resource) || resource instanceof IContainer && SVNUtility.isIgnored(resource)) {
                    return false;
                }
                fullList.add(resource);
                return true;
            }, depth);
            ++n2;
        }
        return fullList.toArray(new IResource[fullList.size()]);
    }

    protected boolean containsImpl(IResource resource) {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            if (element.equals((Object)resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getSize() {
        return this.resources.length;
    }

    public int hashCode() {
        return Objects.hash(this.depth, Arrays.hashCode(this.resources), this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceStatesChangedEvent)) {
            return false;
        }
        ResourceStatesChangedEvent other = (ResourceStatesChangedEvent)obj;
        return this.depth == other.depth && this.type == other.type && Arrays.equals(this.resources, other.resources);
    }

    @Override
    public boolean canSkip() {
        return true;
    }

    @Override
    public boolean canMerge(ResourceStatesChangedEvent e) {
        return this.depth == e.depth && this.type == e.type;
    }

    @Override
    public ResourceStatesChangedEvent merge(ResourceStatesChangedEvent event) {
        IResource[] arr = new IResource[this.resources.length + event.resources.length];
        System.arraycopy(this.resources, 0, arr, 0, this.resources.length);
        System.arraycopy(event.resources, 0, arr, this.resources.length, event.resources.length);
        return new ResourceStatesChangedEvent(arr, this.depth, this.type);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceStatesChangedEvent [depth=");
        builder.append(this.depth);
        builder.append(", size=");
        builder.append(this.resources.length);
        builder.append(", ");
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", ");
        builder.append("resources=");
        builder.append(Arrays.toString(this.resources));
        builder.append("]");
        return builder.toString();
    }
}

