/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.remote.AbstractCopyMoveResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.MoveResourcesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.action.remote.AbstractCopyMoveAction;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;

public class MoveToAction
extends AbstractCopyMoveAction {
    public MoveToAction() {
        super("MoveToAction");
    }

    @Override
    protected AbstractCopyMoveResourcesOperation makeCopyOperation(IRepositoryResource destination, IRepositoryResource[] selected, String message, String name) {
        return new MoveResourcesOperation(destination, selected, message, name);
    }

    @Override
    protected RefreshRemoteResourcesOperation makeRefreshOperation(IRepositoryResource destination, IRepositoryResource[] selected) {
        IRepositoryResource[] toRefresh = new IRepositoryResource[selected.length + 1];
        System.arraycopy(selected, 0, toRefresh, 0, selected.length);
        toRefresh[selected.length] = destination;
        return new RefreshRemoteResourcesOperation(SVNUtility.getCommonParents((IRepositoryResource[])toRefresh));
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (resources.length == 0) {
            return false;
        }
        IRepositoryLocation first = resources[0].getRepositoryLocation();
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource element = iRepositoryResourceArray[n2];
            IRepositoryLocation location = element.getRepositoryLocation();
            if (first != location || element.getSelectedRevision().getKind() != SVNRevision.Kind.HEAD || element instanceof IRepositoryRoot && (((IRepositoryRoot)element).getKind() == 4 || ((IRepositoryRoot)element).getKind() == 0)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

