/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;

public class SVNContainerSelectionGroup
extends ContainerSelectionGroup {
    public SVNContainerSelectionGroup(Composite parent, Listener listener) {
        super(parent, listener, false, "", false);
    }

    public void createContents(String message, int heightHint, int widthHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    public void createContents(String message, int heightHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    public static class SVNContainerCheckOutSelectionVerifier
    extends SVNContainerSelectionVerifier {
        protected static String WARNING_MESSAGE;

        public SVNContainerCheckOutSelectionVerifier() {
            WARNING_MESSAGE = SVNUIMessages.SVNContainerSelectionGroup_Verifier_NonSVNWarning;
        }

        @Override
        protected String getWarningMessageImpl(Control input) {
            SVNContainerSelectionGroup control = (SVNContainerSelectionGroup)input;
            IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(control.getContainerFullPath());
            if (!FileUtility.isConnected((IResource)destinationRoot)) {
                return WARNING_MESSAGE;
            }
            return null;
        }

        @Override
        protected boolean isNonSVNCheckDisabled() {
            return false;
        }
    }

    public static class SVNContainerSelectionVerifier
    extends AbstractFormattedVerifier {
        protected static String ERROR_MESSAGE;
        protected static String DESTINATION_IS_DETACHED_FROM_SVN;
        protected static String DESTINATION_DIRECTORY_IS_DELETED;
        protected static String DESTINATION_DIRECTORY_IS_OBSTRUCTED;

        public SVNContainerSelectionVerifier() {
            super("");
            ERROR_MESSAGE = SVNUIMessages.SVNContainerSelectionGroup_Verifier_NotSelected;
            DESTINATION_IS_DETACHED_FROM_SVN = SVNUIMessages.SVNContainerSelectionGroup_Verifier_NonSVN;
            DESTINATION_DIRECTORY_IS_DELETED = SVNUIMessages.SVNContainerSelectionGroup_Verifier_Deleted;
            DESTINATION_DIRECTORY_IS_OBSTRUCTED = SVNUIMessages.SVNContainerSelectionGroup_Verifier_Obstructed;
        }

        @Override
        protected String getErrorMessageImpl(Control input) {
            SVNContainerSelectionGroup control = (SVNContainerSelectionGroup)input;
            if (control.getContainerFullPath() == null) {
                return ERROR_MESSAGE;
            }
            IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(control.getContainerFullPath());
            ILocalResource localDest = SVNRemoteStorage.instance().asLocalResource(destinationRoot);
            if (IStateFilter.SF_INTERNAL_INVALID.accept(localDest)) {
                return this.isNonSVNCheckDisabled() ? DESTINATION_IS_DETACHED_FROM_SVN : null;
            }
            if (IStateFilter.SF_DELETED.accept(localDest)) {
                return DESTINATION_DIRECTORY_IS_DELETED;
            }
            if (IStateFilter.SF_OBSTRUCTED.accept(localDest)) {
                return DESTINATION_DIRECTORY_IS_OBSTRUCTED;
            }
            return null;
        }

        @Override
        protected String getWarningMessageImpl(Control input) {
            return null;
        }

        protected boolean isNonSVNCheckDisabled() {
            return true;
        }
    }
}

