/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.history.ISVNHistoryViewInfo;
import org.eclipse.team.svn.ui.history.data.HistoryCategory;
import org.eclipse.team.svn.ui.history.data.SVNChangedPathData;
import org.eclipse.team.svn.ui.history.data.SVNLocalFileRevision;
import org.eclipse.team.svn.ui.history.model.ILogNode;

public class RootHistoryCategory
extends HistoryCategory {
    public static String[] NO_REMOTE;
    public static String[] NO_LOCAL;
    public static String[] NO_REVS;
    public static String[] PENDING;
    protected Object[] allHistory;
    protected SVNLocalFileRevision[] localHistory;
    protected SVNLogEntry[] remoteHistory;
    protected HistoryCategory[] categoriesBoth;
    protected HistoryCategory[] categoriesRemote;
    protected HistoryCategory[] categoriesLocal;
    protected Map<Object, SVNChangedPathData[]> pathData;
    protected Set<String> relatedPathsPrefixes;
    protected Set<String> relatedParents;
    protected ISVNHistoryViewInfo info;

    public RootHistoryCategory(ISVNHistoryViewInfo info) {
        super(0, null);
        if (NO_REMOTE == null) {
            NO_REMOTE = new String[]{SVNUIMessages.LogMessagesComposite_NoRemote};
            NO_LOCAL = new String[]{SVNUIMessages.LogMessagesComposite_NoLocal};
            NO_REVS = new String[]{SVNUIMessages.LogMessagesComposite_NoRevs};
            PENDING = new String[]{SVNUIMessages.RepositoriesView_Model_Pending};
        }
        this.info = info;
        this.pathData = new HashMap<Object, SVNChangedPathData[]>();
    }

    public SVNLogEntry[] getRemoteHistory() {
        return this.remoteHistory;
    }

    public SVNLocalFileRevision[] getLocalHistory() {
        return this.localHistory;
    }

    @Override
    public Object[] getEntries() {
        switch (this.info.getMode()) {
            case 64: {
                return this.getLocalHistoryInternal();
            }
            case 128: {
                return this.getRemoteHistoryInternal();
            }
        }
        return this.getAllHistoryInternal();
    }

    public Collection<String> getRelatedPathPrefixes() {
        return this.relatedPathsPrefixes;
    }

    public Collection<String> getRelatedParents() {
        return this.relatedParents;
    }

    public SVNChangedPathData[] getPathData(ILogNode key) {
        return this.pathData.get(key == null ? null : key.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        ISVNHistoryViewInfo iSVNHistoryViewInfo = this.info;
        synchronized (iSVNHistoryViewInfo) {
            this.localHistory = this.info.getLocalHistory();
            this.remoteHistory = this.info.getRemoteHistory();
            if (this.localHistory == null) {
                this.allHistory = this.remoteHistory;
            } else if (this.remoteHistory == null) {
                this.allHistory = this.localHistory;
            } else {
                this.allHistory = new Object[this.localHistory.length + this.remoteHistory.length];
                System.arraycopy(this.localHistory, 0, this.allHistory, 0, this.localHistory.length);
                System.arraycopy(this.remoteHistory, 0, this.allHistory, this.localHistory.length, this.remoteHistory.length);
            }
            this.collectRelatedNodes();
            this.collectCategoriesAndMapData();
        }
    }

    protected void collectRelatedNodes() {
        this.relatedPathsPrefixes = null;
        this.relatedParents = null;
        if (this.remoteHistory != null) {
            SVNLogPath[] changes = null;
            SVNLogEntry[] sVNLogEntryArray = this.remoteHistory;
            int n = this.remoteHistory.length;
            int n2 = 0;
            while (n2 < n) {
                SVNLogEntry msg = sVNLogEntryArray[n2];
                if (msg.changedPaths != null && msg.changedPaths.length > 0) {
                    changes = msg.changedPaths;
                    break;
                }
                ++n2;
            }
            if (changes != null) {
                String baseUrl = this.info.getRepositoryResource().getUrl();
                String changePath = changes[0].path;
                int idx = -1;
                while (changePath.length() > 0 && (idx = baseUrl.indexOf(changePath)) == -1) {
                    changePath = new Path(changePath).removeLastSegments(1).toString();
                }
                if (idx != -1 && idx < baseUrl.length()) {
                    String relatedPathsPrefix = baseUrl.substring(idx + 1);
                    this.relatedPathsPrefixes = new HashSet<String>();
                    this.relatedParents = new HashSet<String>();
                    SVNLogEntry[] sVNLogEntryArray2 = this.remoteHistory;
                    int n3 = this.remoteHistory.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SVNLogEntry msg = sVNLogEntryArray2[n4];
                        this.relatedPathsPrefixes.add(relatedPathsPrefix);
                        if (msg.changedPaths != null && msg.changedPaths.length > 0) {
                            relatedPathsPrefix = this.getNextPrefix(msg, relatedPathsPrefix);
                        }
                        ++n4;
                    }
                }
            }
        }
    }

    protected String getNextPrefix(SVNLogEntry message, String current) {
        SVNLogPath[] changes;
        String checked = "/" + current;
        SVNLogPath[] sVNLogPathArray = changes = message.changedPaths;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            SVNLogPath change = sVNLogPathArray[n2];
            if (change.copiedFromPath != null && checked.startsWith(change.path)) {
                String rest = checked.substring(change.path.length());
                String relatedParent = change.copiedFromPath.substring(1);
                this.relatedParents.add(relatedParent);
                this.relatedParents.add(change.path.substring(1));
                return relatedParent + rest;
            }
            ++n2;
        }
        return current;
    }

    protected void collectCategoriesAndMapData() {
        SVNLogEntry element;
        int n;
        int n2;
        Object[] objectArray;
        this.pathData.clear();
        ArrayList<HistoryCategory> categoriesAll = new ArrayList<HistoryCategory>();
        ArrayList<HistoryCategory> categoriesLocal = new ArrayList<HistoryCategory>();
        ArrayList<HistoryCategory> categoriesRemote = new ArrayList<HistoryCategory>();
        ArrayList<SVNLogEntry> todayEntriesAll = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> yesterdayEntriesAll = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> weekEntriesAll = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> monthEntriesAll = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> earlierEntriesAll = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> todayEntriesLocal = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> yesterdayEntriesLocal = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> weekEntriesLocal = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> monthEntriesLocal = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> earlierEntriesLocal = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> todayEntriesRemote = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> yesterdayEntriesRemote = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> weekEntriesRemote = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> monthEntriesRemote = new ArrayList<SVNLogEntry>();
        ArrayList<SVNLogEntry> earlierEntriesRemote = new ArrayList<SVNLogEntry>();
        Calendar yesterdayCal = Calendar.getInstance();
        yesterdayCal.set(11, 0);
        yesterdayCal.set(12, 0);
        yesterdayCal.set(13, 0);
        long yesterdayDate = yesterdayCal.getTimeInMillis();
        Calendar beforeYesterdayCal = Calendar.getInstance();
        beforeYesterdayCal.roll(6, -1);
        beforeYesterdayCal.set(11, 0);
        beforeYesterdayCal.set(12, 0);
        beforeYesterdayCal.set(13, 0);
        long beforeYesterdayDate = beforeYesterdayCal.getTimeInMillis();
        Calendar weekCal = Calendar.getInstance();
        weekCal.roll(6, -7);
        weekCal.set(11, 0);
        weekCal.set(12, 0);
        weekCal.set(13, 0);
        long lastWeekDate = weekCal.getTimeInMillis();
        Calendar monthCal = Calendar.getInstance();
        monthCal.set(5, 1);
        monthCal.set(11, 0);
        monthCal.set(12, 0);
        monthCal.set(13, 0);
        long lastMonthDate = monthCal.getTimeInMillis();
        if (this.remoteHistory != null) {
            objectArray = this.remoteHistory;
            n2 = this.remoteHistory.length;
            n = 0;
            while (n < n2) {
                element = objectArray[n];
                this.mapPathData(element);
                if (element.date >= yesterdayDate) {
                    todayEntriesAll.add(element);
                    todayEntriesRemote.add(element);
                } else if (element.date < yesterdayDate && element.date >= beforeYesterdayDate) {
                    yesterdayEntriesAll.add(element);
                    yesterdayEntriesRemote.add(element);
                } else if (element.date < beforeYesterdayDate && element.date >= lastWeekDate) {
                    weekEntriesAll.add(element);
                    weekEntriesRemote.add(element);
                } else if (element.date < lastWeekDate && element.date >= lastMonthDate) {
                    monthEntriesAll.add(element);
                    monthEntriesRemote.add(element);
                } else {
                    earlierEntriesAll.add(element);
                    earlierEntriesRemote.add(element);
                }
                ++n;
            }
        }
        if (this.localHistory != null) {
            objectArray = this.localHistory;
            n2 = this.localHistory.length;
            n = 0;
            while (n < n2) {
                element = objectArray[n];
                if (element.getTimestamp() >= yesterdayDate) {
                    todayEntriesAll.add(element);
                    todayEntriesLocal.add(element);
                } else if (element.getTimestamp() < yesterdayDate && element.getTimestamp() >= beforeYesterdayDate) {
                    yesterdayEntriesAll.add(element);
                    yesterdayEntriesLocal.add(element);
                } else if (element.getTimestamp() < beforeYesterdayDate && element.getTimestamp() >= lastWeekDate) {
                    weekEntriesAll.add(element);
                    weekEntriesLocal.add(element);
                } else if (element.getTimestamp() < lastWeekDate && element.getTimestamp() >= lastMonthDate) {
                    monthEntriesAll.add(element);
                    monthEntriesLocal.add(element);
                } else {
                    earlierEntriesAll.add(element);
                    earlierEntriesLocal.add(element);
                }
                ++n;
            }
        }
        HistoryCategory cat = null;
        if (todayEntriesAll.size() > 0) {
            cat = new HistoryCategory(1, todayEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (yesterdayEntriesAll.size() > 0) {
            cat = new HistoryCategory(2, yesterdayEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (weekEntriesAll.size() > 0) {
            cat = new HistoryCategory(3, weekEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (monthEntriesAll.size() > 0) {
            cat = new HistoryCategory(4, monthEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (earlierEntriesAll.size() > 0) {
            cat = new HistoryCategory(5, earlierEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (todayEntriesLocal.size() > 0) {
            cat = new HistoryCategory(1, todayEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (yesterdayEntriesLocal.size() > 0) {
            cat = new HistoryCategory(2, yesterdayEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (weekEntriesLocal.size() > 0) {
            cat = new HistoryCategory(3, weekEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (monthEntriesLocal.size() > 0) {
            cat = new HistoryCategory(4, monthEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (earlierEntriesLocal.size() > 0) {
            cat = new HistoryCategory(5, earlierEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (todayEntriesRemote.size() > 0) {
            cat = new HistoryCategory(1, todayEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (yesterdayEntriesRemote.size() > 0) {
            cat = new HistoryCategory(2, yesterdayEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (weekEntriesRemote.size() > 0) {
            cat = new HistoryCategory(3, weekEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (monthEntriesRemote.size() > 0) {
            cat = new HistoryCategory(4, monthEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (earlierEntriesRemote.size() > 0) {
            cat = new HistoryCategory(5, earlierEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        this.categoriesBoth = categoriesAll.size() > 0 ? categoriesAll.toArray(new HistoryCategory[categoriesAll.size()]) : null;
        this.categoriesLocal = categoriesLocal.size() > 0 ? categoriesLocal.toArray(new HistoryCategory[categoriesLocal.size()]) : null;
        this.categoriesRemote = categoriesRemote.size() > 0 ? categoriesRemote.toArray(new HistoryCategory[categoriesRemote.size()]) : null;
    }

    protected void mapPathData(SVNLogEntry key) {
        SVNChangedPathData[] pathData = new SVNChangedPathData[key.changedPaths == null ? 0 : key.changedPaths.length];
        int i = 0;
        while (i < pathData.length) {
            String path = key.changedPaths[i].path;
            path = path.startsWith("/") ? path.substring(1) : path;
            int idx = path.lastIndexOf("/");
            pathData[i] = new SVNChangedPathData(key.changedPaths[i].action, idx != -1 ? path.substring(idx + 1) : path, idx != -1 ? path.substring(0, idx) : "", key.changedPaths[i].copiedFromRevision != -1L ? key.changedPaths[i].copiedFromPath : "", key.changedPaths[i].copiedFromRevision);
            ++i;
        }
        this.pathData.put(key, pathData);
        SVNLogEntry[] children = key.getChildren();
        if (children != null) {
            SVNLogEntry[] sVNLogEntryArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                SVNLogEntry child = sVNLogEntryArray[n2];
                this.mapPathData(child);
                ++n2;
            }
        }
    }

    protected Object[] getLocalHistoryInternal() {
        if (this.localHistory == null) {
            return NO_LOCAL;
        }
        return this.info.isGrouped() ? this.categoriesLocal : this.localHistory;
    }

    protected Object[] getRemoteHistoryInternal() {
        if (this.remoteHistory == null) {
            return this.info.isPending() ? PENDING : NO_REMOTE;
        }
        return this.info.isGrouped() ? this.categoriesRemote : this.remoteHistory;
    }

    protected Object[] getAllHistoryInternal() {
        if (this.allHistory == null) {
            return this.info.isPending() ? PENDING : NO_REVS;
        }
        return this.info.isGrouped() && this.categoriesBoth != null ? this.categoriesBoth : this.allHistory;
    }
}

