/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelParticipantAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.action.IResourceSelector;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.svn.ui.synchronize.action.logicalmodel.SVNSynchronizationResourceMappingContext;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractSynchronizeLogicalModelAction
extends ResourceModelParticipantAction {
    protected IResourceSelector syncInfoSelector;

    public AbstractSynchronizeLogicalModelAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.setEnabled(false);
        this.setToolTipText(text);
        this.createSyncInfoSelector();
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        return this.getFilteredResources().length > 0;
    }

    protected ResourceMappingContext getResourceMappingContext() {
        return new SVNSynchronizationResourceMappingContext(this.getSynchronizationContext());
    }

    protected void createSyncInfoSelector() {
        this.syncInfoSelector = new IResourceSelector(){

            @Override
            public IResource[] getSelectedResources() {
                return this.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(IStateFilter.SF_ALL, false));
            }

            @Override
            public IResource[] getSelectedResources(IStateFilter filter) {
                if (filter instanceof ISyncStateFilter) {
                    return this.getSelectedResources((ISyncStateFilter)filter);
                }
                return this.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(filter, false));
            }

            @Override
            public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                return this.getSelectedResources(filter);
            }

            @Override
            public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                return this.getSelectedResources(filter);
            }

            private IResource[] getSelectedResources(ISyncStateFilter filter) {
                HashSet<Object> retVal = new HashSet<Object>();
                try {
                    IResource[] filtered;
                    IResource[] iResourceArray = filtered = AbstractSynchronizeLogicalModelAction.this.getFilteredResources();
                    int n = filtered.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource element = iResourceArray[n2];
                        AbstractSVNSyncInfo info = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(element);
                        if (info != null) {
                            ILocalResource local = info.getLocalResource();
                            ILocalResource remote = info.getRemoteChangeResource();
                            if (remote instanceof IResourceChange && filter.acceptRemote(remote.getResource(), remote.getStatus(), remote.getChangeMask()) || filter.accept(local)) {
                                retVal.add(local.getResource());
                            }
                        }
                        ++n2;
                    }
                    IResource[] filteredResources = retVal.toArray(new IResource[retVal.size()]);
                    if (filter.acceptGroupNodes()) {
                        ArrayList<IResource> allSelected = new ArrayList<IResource>(Arrays.asList(AbstractSynchronizeLogicalModelAction.this.getAllSelectedResources()));
                        IResource[] iResourceArray2 = filteredResources;
                        int n3 = filteredResources.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IResource filteredResource = iResourceArray2[n4];
                            ArrayList<IContainer> parents = new ArrayList<IContainer>();
                            IContainer parent = filteredResource.getParent();
                            while (parent != null) {
                                ILocalResource local;
                                AbstractSVNSyncInfo info = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo((IResource)parent);
                                if (info != null && !IStateFilter.SF_UNVERSIONED_EXTERNAL.accept(local = info.getLocalResource())) {
                                    parents.add(parent);
                                }
                                if (allSelected.contains(parent)) {
                                    retVal.addAll(parents);
                                    break;
                                }
                                parent = parent.getParent();
                            }
                            ++n4;
                        }
                    }
                }
                catch (Exception ex) {
                    LoggedOperation.reportError((String)this.getClass().getName(), (Throwable)ex);
                }
                return retVal.toArray(new IResource[retVal.size()]);
            }
        };
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter();
    }

    public AbstractSVNSyncInfo[] getSVNSyncInfos() {
        ArrayList<AbstractSVNSyncInfo> filtered = new ArrayList<AbstractSVNSyncInfo>();
        try {
            IResource[] iResourceArray = this.getFilteredResources();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(resource);
                if (syncInfo != null) {
                    filtered.add(syncInfo);
                }
                ++n2;
            }
        }
        catch (TeamException te) {
            LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)te);
        }
        return filtered.toArray(new AbstractSVNSyncInfo[filtered.size()]);
    }

    protected IResource[] getFilteredResources() {
        HashSet<IResource> filtered = new HashSet<IResource>();
        try {
            IDiff[] affectedDiffs;
            IResourceDiffTree diffTree = this.getSynchronizationContext().getDiffTree();
            IDiff[] iDiffArray = affectedDiffs = diffTree.getDiffs(this.getResourceTraversals(this.getStructuredSelection(), (IProgressMonitor)new NullProgressMonitor()));
            int n = affectedDiffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff currentDiff = iDiffArray[n2];
                IResource resource = ResourceDiffTree.getResourceFor((IDiff)currentDiff);
                SyncInfo info = UpdateSubscriber.instance().getSyncInfo(resource);
                if (info != null && this.getSyncInfoFilter().select(info)) {
                    filtered.add(resource);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex);
        }
        return filtered.toArray(new IResource[filtered.size()]);
    }

    public IResource[] getAllSelectedResources() {
        IStructuredSelection selection = this.getStructuredSelection();
        ArrayList<IResource> retVal = new ArrayList<IResource>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object adapter = Platform.getAdapterManager().getAdapter(it.next(), IResource.class);
            if (adapter == null) continue;
            retVal.add((IResource)adapter);
        }
        return retVal.toArray(new IResource[retVal.size()]);
    }

    public IResource getSelectedResource() {
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object adapter = Platform.getAdapterManager().getAdapter(it.next(), IResource.class);
            if (adapter == null) continue;
            return (IResource)adapter;
        }
        return null;
    }

    public AbstractSVNSyncInfo getSelectedSVNSyncInfo() {
        IResource resource = this.getSelectedResource();
        try {
            return resource == null ? null : (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(resource);
        }
        catch (TeamException ex) {
            LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex);
            return null;
        }
    }

    public void run() {
        if (this.needsToSaveDirtyEditors() && !this.saveAllEditors(this.confirmSaveOfDirtyEditor())) {
            return;
        }
        this.runOperation();
    }

    protected boolean confirmSaveOfDirtyEditor() {
        return true;
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    public final boolean saveAllEditors(boolean confirm) {
        Object[] resources = this.getFilteredResources();
        return IDE.saveAllEditors((IResource[])Utils.getResources((Object[])resources), (boolean)confirm);
    }

    protected void runOperation() {
        IActionOperation op = this.getOperation();
        if (op == null) {
            return;
        }
        UIMonitorUtility.getDisplay().syncExec(() -> {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor));
            }
            catch (InvocationTargetException ex) {
                UILoggedOperation.reportError(op.getOperationName(), ex);
            }
            catch (InterruptedException ex) {
                LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex);
            }
        });
    }

    public IResourceSelector getSyncInfoSelector() {
        return this.syncInfoSelector;
    }

    protected abstract IActionOperation getOperation();
}

