/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.selectresource;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RepositoryTreeComposite;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevisions;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class SelectResourceLocationPage
extends AbstractVerifiedWizardPage {
    protected RepositoryTreeComposite repositoryTree;
    protected IRepositoryResource resource;
    protected Object modelRoot;
    protected boolean showOnlyFolders;

    public SelectResourceLocationPage(boolean showOnlyFolders, Object modelRoot) {
        super(SelectResourceLocationPage.class.getName(), SVNUIMessages.SelectResourceLocationPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.SelectResourceLocationPage_Description);
        this.showOnlyFolders = showOnlyFolders;
        this.modelRoot = modelRoot;
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.repositoryTree = new RepositoryTreeComposite(composite, 2048);
        data = new GridData(1808);
        this.repositoryTree.setLayoutData(data);
        this.repositoryTree.getRepositoryTreeViewer().addSelectionChangedListener(event -> {
            this.resource = null;
            IStructuredSelection sel = (IStructuredSelection)this.repositoryTree.getRepositoryTreeViewer().getSelection();
            if (!sel.isEmpty() && sel.getFirstElement() instanceof RepositoryResource) {
                IRepositoryResource rr = ((RepositoryResource)sel.getFirstElement()).getRepositoryResource();
                if (this.showOnlyFolders && !(rr instanceof IRepositoryFile)) {
                    this.resource = rr;
                } else if (!this.showOnlyFolders && rr instanceof IRepositoryFile) {
                    this.resource = rr;
                }
            }
            this.validateContent();
        });
        this.repositoryTree.setFilter(obj -> !(obj instanceof RepositoryRevisions) && (!this.showOnlyFolders || !(obj instanceof RepositoryFile)));
        if (this.modelRoot != null) {
            this.repositoryTree.setModelRoot(this.modelRoot);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.selectResourceContext");
        return composite;
    }

    public void setModelRoot(Object modelRoot) {
        this.modelRoot = modelRoot;
        this.repositoryTree.setModelRoot(this.modelRoot);
    }

    public IRepositoryResource getRepositoryResource() {
        return this.resource;
    }
}

