/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class CheckoutOperation
extends AbstractActionOperation
implements IResourceProvider {
    protected IProject[] projects;
    protected CheckoutAsOperation[] operations;
    protected ISchedulingRule rule;

    public CheckoutOperation(Map<String, IRepositoryResource> checkoutMap, boolean respectHierarchy, String location, SVNDepth recureDepth, boolean ignoreExternals) {
        super("Operation_CheckOut", SVNMessages.class);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        ArrayList<CheckoutAsOperation> operations = new ArrayList<CheckoutAsOperation>();
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        for (Map.Entry<String, IRepositoryResource> entry : checkoutMap.entrySet()) {
            CheckoutAsOperation coOp = CheckoutOperation.getCheckoutAsOperation(entry.getKey(), entry.getValue(), respectHierarchy, location, recureDepth, ignoreExternals);
            operations.add(coOp);
            projects.add(coOp.getProject());
            rules.add(coOp.getSchedulingRule());
        }
        this.rule = new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        this.projects = projects.toArray(new IProject[projects.size()]);
        this.operations = operations.toArray(new CheckoutAsOperation[operations.size()]);
    }

    @Override
    public int getOperationWeight() {
        return 19;
    }

    @Override
    public IResource[] getResources() {
        return this.projects;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.rule;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.operations.length && !monitor.isCanceled()) {
            this.operations[i].setConsoleStream(this.getConsoleStream());
            ProgressMonitorUtility.doTask(this.operations[i], monitor, 1 * this.projects.length, 1);
            this.reportStatus(this.operations[i].getStatus());
            ++i;
        }
    }

    public static CheckoutAsOperation getCheckoutAsOperation(String name, IRepositoryResource currentResource, boolean respectHierarchy, String location, SVNDepth recureDepth, boolean ignoreExternals) {
        if (location != null && location.trim().length() > 0) {
            return new CheckoutAsOperation(name, currentResource, respectHierarchy, location, recureDepth, ignoreExternals);
        }
        return new CheckoutAsOperation(name, currentResource, recureDepth, ignoreExternals);
    }
}

