/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.team.svn.core.resource.IResourceProvider;

public class ResourcesParentsProvider
implements IResourceProvider {
    protected IResource[] resources;
    protected IResourceProvider provider;

    public ResourcesParentsProvider(IResource[] resources) {
        this.resources = resources;
    }

    public ResourcesParentsProvider(IResourceProvider provider) {
        this.provider = provider;
    }

    @Override
    public IResource[] getResources() {
        IResource[] resources = this.operableData();
        if (resources == null) {
            return new IResource[1];
        }
        HashSet<IResource> resourcesWithParents = new HashSet<IResource>(Arrays.asList(resources));
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            IContainer parent = element.getParent();
            if (parent != null && !(parent instanceof IWorkspaceRoot)) {
                resourcesWithParents.add((IResource)parent);
            }
            ++n2;
        }
        return resourcesWithParents.toArray(new IResource[resourcesWithParents.size()]);
    }

    protected IResource[] operableData() {
        return this.resources == null ? this.provider.getResources() : this.resources;
    }
}

