/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.property.IRevisionPropertiesProvider;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;

public class SetRevisionPropertyOperation
extends AbstractActionOperation {
    protected IRepositoryLocation location;
    protected SVNRevision revision;
    protected IRevisionPropertiesProvider provider;

    public SetRevisionPropertyOperation(IRepositoryLocation location, SVNRevision revision, SVNProperty revProp) {
        this(location, revision, () -> new SVNProperty[]{revProp});
    }

    public SetRevisionPropertyOperation(IRepositoryLocation location, SVNRevision revision, IRevisionPropertiesProvider revPropProvider) {
        super("Operation_SetRevisionProperty", SVNMessages.class);
        this.revision = revision;
        this.provider = revPropProvider;
        this.location = location;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNProperty toSet = this.provider.getRevisionProperties()[0];
        ISVNConnector proxy = this.location.acquireSVNProxy();
        try {
            proxy.setRevisionProperty(new SVNEntryReference(this.location.getUrl(), this.revision), toSet, null, 4L, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            this.location.releaseSVNProxy(proxy);
        }
    }
}

