/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.svn.core.operation.local.GetAllResourcesOperation;
import org.eclipse.team.svn.core.synchronize.IRemoteStatusCache;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class RemoteStatusCache
extends ResourceVariantByteStore
implements IRemoteStatusCache {
    protected Map<IPath, byte[]> resourceStateMap = new HashMap<IPath, byte[]>();
    protected Map<IPath, Set<IResource>> resourceChildrenMap = new HashMap<IPath, Set<IResource>>();

    @Override
    public synchronized boolean containsData() {
        return this.resourceStateMap.size() > 0;
    }

    @Override
    public void dispose() {
    }

    @Override
    public synchronized void clearAll() {
        this.resourceChildrenMap.clear();
        this.resourceStateMap.clear();
    }

    @Override
    public synchronized byte[] getBytes(IResource resource) {
        return this.resourceStateMap.get(resource.getFullPath());
    }

    @Override
    public synchronized boolean setBytes(IResource resource, byte[] bytes) {
        byte[] old = this.resourceStateMap.put(resource.getFullPath(), bytes);
        IPath parentPath = resource.getParent().getFullPath();
        Set<IResource> members = this.resourceChildrenMap.get(parentPath);
        if (members == null) {
            members = new HashSet<IResource>();
            this.resourceChildrenMap.put(parentPath, members);
        }
        members.add(resource);
        return !this.equals(old, bytes);
    }

    @Override
    public synchronized boolean flushBytes(IResource resource, int depth) {
        HashSet removedSet = new HashSet();
        boolean retVal = this.resourceStateMap.remove(resource.getFullPath()) != null;
        this.traverse(resource, depth, (IPath path, byte[] data) -> {
            boolean bl = removedSet.add(path);
        });
        for (IPath current : removedSet) {
            this.resourceStateMap.remove(current);
            this.resourceChildrenMap.remove(current);
        }
        Set<IResource> members = this.resourceChildrenMap.get(resource.getParent().getFullPath());
        if (members != null) {
            members.remove(resource);
        }
        return retVal;
    }

    public synchronized boolean deleteBytes(IResource resource) {
        return this.flushBytes(resource, 0);
    }

    @Override
    public synchronized IResource[] members(IResource resource) {
        Set<IResource> members = this.resourceChildrenMap.get(resource.getFullPath());
        return members == null ? FileUtility.NO_CHILDREN : members.toArray(new IResource[members.size()]);
    }

    @Override
    public synchronized IResource[] allMembers(IResource resource) {
        if (!(resource instanceof IContainer)) {
            return FileUtility.NO_CHILDREN;
        }
        IResource[] known = this.members(resource);
        ArrayList<Object> members = known.length == 0 ? new ArrayList() : new ArrayList<IResource>(Arrays.asList(known));
        if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.svn.core.svnnature") != null) {
            IContainer container = (IContainer)resource;
            GetAllResourcesOperation op = new GetAllResourcesOperation(container);
            ProgressMonitorUtility.doTaskExternal(op, (IProgressMonitor)new NullProgressMonitor());
            IResource[] children = op.getChildren();
            if (children.length > 0) {
                members.addAll(Arrays.asList(children));
            }
        }
        return members.toArray(new IResource[members.size()]);
    }

    @Override
    public synchronized void traverse(IResource[] resources, int depth, IRemoteStatusCache.ICacheVisitor visitor) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            this.traverse(element, depth, visitor);
            ++n2;
        }
    }

    protected void traverse(IResource resource, int depth, IRemoteStatusCache.ICacheVisitor visitor) {
        IPath base = resource.getFullPath();
        for (Map.Entry<IPath, byte[]> entry : this.resourceStateMap.entrySet()) {
            IPath current = entry.getKey();
            if (!this.isChildOf(base, current, depth)) continue;
            visitor.visit(current, entry.getValue());
        }
    }

    protected boolean isChildOf(IPath base, IPath current, int depth) {
        int matchingSegmentsCount;
        int cachedSegmentsCount;
        int difference;
        return base.isPrefixOf(current) && ((difference = (cachedSegmentsCount = current.segmentCount()) - (matchingSegmentsCount = base.matchingFirstSegments(current))) >= 0 && depth == 2 || depth >= difference);
    }
}

