/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.action.AbstractWorkingCopyAction;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;

public class CompareWithWorkingCopyAction
extends AbstractWorkingCopyAction {
    public static final IStateFilter COMPARE_FILTER = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_EXCLUDE_DELETED.accept(resource, state, mask) | (mask & 4) != 0;
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_EXCLUDE_DELETED.accept(resource, state, mask);
        }
    };

    @Override
    public void runImpl(IAction action) {
        IResource resource = this.getSelectedResources()[0];
        ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resource);
        IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
        remote.setSelectedRevision(SVNRevision.BASE);
        this.runScheduled((IActionOperation)new CompareResourcesOperation(local, remote));
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(COMPARE_FILTER);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

