/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class MoveProjectsToWorkingSetOperation
extends AbstractWorkingCopyOperation {
    protected String workingSetName;

    public MoveProjectsToWorkingSetOperation(IResource[] projects, String workingSetName) {
        super("Operation_MoveToWorkingSet", SVNUIMessages.class, projects);
        this.workingSetName = workingSetName;
    }

    public MoveProjectsToWorkingSetOperation(IResourceProvider provider, String workingSetName) {
        super("Operation_MoveToWorkingSet", SVNUIMessages.class, provider);
        this.workingSetName = workingSetName;
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IWorkingSet[] workingSets;
        IResource[] projects = this.operableData();
        IWorkingSet wSet = null;
        IWorkingSetManager workingSetManager = SVNTeamUIPlugin.instance().getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSets = workingSetManager.getWorkingSets();
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (workingSet.getName().equals(this.workingSetName)) {
                wSet = workingSet;
                ArrayList<IAdaptable> existing = new ArrayList<IAdaptable>(Arrays.asList(wSet.getElements()));
                existing.addAll(Arrays.asList(projects));
                wSet.setElements(existing.toArray(new IAdaptable[existing.size()]));
                break;
            }
            ++n2;
        }
        if (wSet == null) {
            wSet = workingSetManager.createWorkingSet(this.workingSetName, (IAdaptable[])projects);
            wSet.setId("org.eclipse.ui.resourceWorkingSetPage");
            workingSetManager.addWorkingSet(wSet);
        }
    }
}

