/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.extension.properties.PredefinedProperty;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.ApplyPropertyMethodComposite;
import org.eclipse.team.svn.ui.properties.AbstractPropertyEditPanel;

public class ResourcePropertyEditPanel
extends AbstractPropertyEditPanel {
    public static int SINGLE_FILE = 0;
    public static int MULTIPLE_FILES = 1;
    public static int MIXED_RESOURCES = 2;
    protected Button recursiveButton;
    protected ApplyPropertyMethodComposite applyComposite;
    protected int resourcesType;
    protected boolean recursiveSelected;
    protected boolean applyToAll;
    protected boolean applyToFiles;
    protected boolean applyToFolders;
    protected IResource[] selectedResources;
    protected boolean strict;
    protected int mask;

    public ResourcePropertyEditPanel(SVNProperty[] data, IResource[] selectedResources, boolean strict) {
        super(data, data != null ? SVNUIMessages.PropertyEditPanel_Title_Edit : SVNUIMessages.PropertyEditPanel_Title_Add, SVNUIMessages.PropertyEditPanel_Description);
        this.strict = strict;
        this.selectedResources = selectedResources;
        this.resourcesType = this.computeResourcesType();
        this.mask = 0;
        IResource[] iResourceArray = this.selectedResources;
        int n = this.selectedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 2 || resource.getType() == 4) {
                this.mask |= 6;
            } else if (resource.getType() == 1) {
                this.mask |= 2;
            }
            ++n2;
        }
        this.fillVerifiersMap();
    }

    @Override
    protected boolean isPropertyAccepted(PredefinedProperty property) {
        return (property.type & 1) == 0 && (property.type & this.mask) != 0;
    }

    @Override
    protected IRepositoryResource getRepostioryResource() {
        return SVNRemoteStorage.instance().asRepositoryResource(this.selectedResources[0]);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isRecursiveSelected() {
        return this.recursiveSelected;
    }

    public int getApplyMethod() {
        return this.applyComposite == null ? 0 : this.applyComposite.getApplyMethod();
    }

    public String getFilterMask() {
        return this.applyComposite == null ? "" : this.applyComposite.getFilterMask();
    }

    public boolean useMask() {
        return this.applyComposite == null ? false : this.applyComposite.useMask();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        super.createControlsImpl(parent);
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
                this.recursiveButton = new Button(parent, 32);
                this.recursiveButton.setText(SVNUIMessages.PropertyEditPanel_Recursively);
                this.recursiveButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ResourcePropertyEditPanel.this.refreshControlsEnablement();
                        ResourcePropertyEditPanel.this.validateContent();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            this.applyComposite = new ApplyPropertyMethodComposite(parent, 0, this, this.resourcesType);
            this.applyComposite.setLayoutData(new GridData(768));
        }
        if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
            this.refreshControlsEnablement();
        }
    }

    @Override
    public String getHelpId() {
        return "org.eclipse.team.svn.help.setPropsDialogContext";
    }

    protected int computeResourcesType() {
        boolean singleResource = this.selectedResources.length == 1;
        boolean allFiles = true;
        IResource[] iResourceArray = this.selectedResources;
        int n = this.selectedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            if (!(element instanceof IFile)) {
                allFiles = false;
                break;
            }
            ++n2;
        }
        if (allFiles) {
            return singleResource ? SINGLE_FILE : MULTIPLE_FILES;
        }
        return MIXED_RESOURCES;
    }

    @Override
    protected void saveChangesImpl() {
        super.saveChangesImpl();
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
                this.recursiveSelected = this.recursiveButton.getSelection();
            }
            if (this.applyComposite.isEnabled()) {
                this.applyComposite.saveChanges();
            }
        }
    }

    protected void refreshControlsEnablement() {
        this.applyComposite.setEnabled(this.recursiveButton.getSelection());
    }

    @Override
    protected Point getPrefferedSizeImpl() {
        return new Point(590, -1);
    }
}

