/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class FileReplaceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1 || event.getType() == 8) {
            try {
                ArrayList added = new ArrayList();
                event.getDelta().accept(delta -> {
                    int kind;
                    if (delta.getResource().getType() == 1 && ((kind = delta.getKind()) == 1 || kind == 4)) {
                        added.add((IFile)delta.getResource());
                    }
                    return true;
                });
                if (!added.isEmpty()) {
                    this.processResources(added.toArray(new IResource[0]));
                }
            }
            catch (CoreException e) {
                LoggedOperation.reportError(this.getClass().getName(), e);
            }
        }
    }

    protected void processResources(IResource[] resources) {
        FileReplaceListenerOperation mainOp = new FileReplaceListenerOperation(resources);
        CompositeOperation cmpOp = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        cmpOp.add(mainOp);
        cmpOp.add(new RefreshResourcesOperation(mainOp, 0, RefreshResourcesOperation.REFRESH_CHANGES));
        ProgressMonitorUtility.doTaskScheduledDefault(cmpOp);
    }

    private class FileReplaceListenerOperation
    extends AbstractWorkingCopyOperation
    implements IResourceProvider {
        private ArrayList<IResource> processedResources;

        public FileReplaceListenerOperation(IResource[] resources) {
            super("Operation_FileReplaceListener", SVNMessages.class, resources);
            this.processedResources = new ArrayList();
        }

        @Override
        public IResource[] getResources() {
            return this.processedResources.toArray(new IResource[this.processedResources.size()]);
        }

        @Override
        protected void runImpl(IProgressMonitor monitor) throws Exception {
            IResource[] resources = this.operableData();
            SVNRemoteStorage.instance().refreshLocalResources(resources, 0);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                block18: {
                    IResource file = iResourceArray[n2];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ILocalResource local = SVNRemoteStorage.instance().asLocalResource(file);
                    if (IStateFilter.SF_PREREPLACEDREPLACED.accept(local)) {
                        IContainer parent = file.getParent();
                        ILocalResource localParent = SVNRemoteStorage.instance().asLocalResource((IResource)parent);
                        if (!IStateFilter.SF_DELETED.accept(localParent)) {
                            File originalFile = new File(FileUtility.getWorkingCopyPath(file));
                            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(file);
                            ISVNConnector proxy = location.acquireSVNProxy();
                            OutputStreamComparator oStream = null;
                            try {
                                try {
                                    oStream = new OutputStreamComparator(originalFile);
                                    proxy.streamFileContent(new SVNEntryRevisionReference(originalFile.getAbsolutePath(), null, SVNRevision.BASE), 8192L, oStream, new SVNProgressMonitor(this, monitor, null));
                                    this.processedResources.add(file);
                                    originalFile.delete();
                                    proxy.revert(new String[]{originalFile.getAbsolutePath()}, SVNDepth.EMPTY, null, 0L, new SVNProgressMonitor(this, monitor, null));
                                }
                                catch (UnreportableException unreportableException) {
                                    if (oStream != null) {
                                        try {
                                            oStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    location.releaseSVNProxy(proxy);
                                    break block18;
                                }
                            }
                            catch (Throwable throwable) {
                                if (oStream != null) {
                                    try {
                                        oStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                location.releaseSVNProxy(proxy);
                                throw throwable;
                            }
                            if (oStream != null) {
                                try {
                                    oStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            location.releaseSVNProxy(proxy);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private class OutputStreamComparator
    extends OutputStream {
        private FileInputStream stream;
        private byte[] buffer;

        public OutputStreamComparator(File src1) throws FileNotFoundException {
            this.stream = new FileInputStream(src1);
        }

        @Override
        public void write(int b) throws IOException {
            if (b != this.stream.read()) {
                throw new UnreportableException();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] b1 = b;
            if (b.length != len) {
                b1 = Arrays.copyOfRange(b, off, off + len);
            }
            if (this.buffer == null || this.buffer.length != b1.length) {
                this.buffer = new byte[b1.length];
            }
            this.stream.read(this.buffer);
            if (!Arrays.equals(b1, this.buffer)) {
                throw new UnreportableException();
            }
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }
}

