/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.discovery.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class WebUtil {
    private static int STATUS_OK = 200;
    protected static Authenticator authenticator;
    protected static boolean isProxyInitialized;

    public static void downloadResource(File target, URL sourceUrl, IProgressMonitor monitor) throws IOException {
        block25: {
            monitor.beginTask(BaseMessages.format(SVNMessages.WebUtil_task_retrievingUrl, sourceUrl.toString()), -1);
            WebUtil.initProxyData(sourceUrl.getHost());
            try {
                HttpURLConnection con = (HttpURLConnection)sourceUrl.openConnection();
                int result = con.getResponseCode();
                if (result == STATUS_OK) {
                    InputStream in = con.getInputStream();
                    try {
                        in = new BufferedInputStream(in);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
                        try {
                            Throwable throwable = null;
                            Object var8_10 = null;
                            try {
                                try {
                                    int i;
                                    while ((i = in.read()) != -1) {
                                        ((OutputStream)out).write(i);
                                    }
                                }
                                finally {
                                    if (out != null) {
                                        ((OutputStream)out).close();
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            ((OutputStream)out).close();
                            target.delete();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block25;
                }
                throw new IOException(BaseMessages.format(SVNMessages.WebUtil_cannotDownload, new Object[]{sourceUrl.toString(), result}));
            }
            finally {
                monitor.done();
            }
        }
    }

    public static boolean verifyAvailability(URL[] locations, boolean one, IProgressMonitor monitor) {
        if (locations.length == 0) {
            throw new IllegalArgumentException();
        }
        monitor.beginTask(BaseMessages.format(SVNMessages.WebUtil_task_verifyingUrl, locations[0].toString()), -1);
        try {
            int countFound = 0;
            URL[] uRLArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    int result;
                    URL location = uRLArray[n2];
                    WebUtil.initProxyData(location.getHost());
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    try {
                        HttpURLConnection con = (HttpURLConnection)location.openConnection();
                        result = con.getResponseCode();
                    }
                    catch (IOException e) {
                        if (!one || e instanceof UnknownHostException) {
                            monitor.done();
                            return false;
                        }
                        break block17;
                    }
                    if (result == STATUS_OK) {
                        ++countFound;
                        if (one) {
                            return true;
                        }
                    } else if (!one) {
                        return false;
                    }
                }
                ++n2;
            }
            boolean bl = countFound == locations.length;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public static void setAuthenticator(Authenticator authenticator) {
        WebUtil.authenticator = authenticator;
    }

    protected static void initProxyData(String host) {
        IProxyData proxyData;
        if (!isProxyInitialized && (proxyData = SVNUtility.getProxyData(host, "HTTP")) != null) {
            String proxyHost = proxyData.getHost();
            int proxyPort = proxyData.getPort();
            if (proxyPort == -1) {
                proxyPort = 0;
            }
            System.getProperties().put("http.proxyHost", proxyHost);
            System.getProperties().put("http.proxyPort", String.valueOf(proxyPort));
            if (proxyData.isRequiresAuthentication()) {
                Authenticator.setDefault(authenticator);
            }
            isProxyInitialized = true;
        }
    }
}

