/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public abstract class AbstractGetFileContentOperation
extends AbstractActionOperation {
    protected File tmpFile;

    public AbstractGetFileContentOperation(String getOperationType) {
        super("Operation_GetFileContent_" + getOperationType, SVNMessages.class);
    }

    public String getTemporaryPath() {
        return this.tmpFile == null ? null : this.tmpFile.getAbsolutePath();
    }

    public InputStream getContent() {
        final InputStream[] retVal = new InputStream[]{new ByteArrayInputStream(new byte[0])};
        if (this.tmpFile != null && this.tmpFile.exists()) {
            ProgressMonitorUtility.doTaskExternal(new AbstractActionOperation("Operation_GetFileContent_CreateStream", SVNMessages.class){

                @Override
                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    retVal[0] = new FileInputStream(AbstractGetFileContentOperation.this.tmpFile);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        return retVal[0];
    }

    public void setContent(final byte[] data) {
        ProgressMonitorUtility.doTaskExternal(new AbstractActionOperation("Operation_GetFileContent_SetContent", SVNMessages.class){

            @Override
            protected void runImpl(IProgressMonitor monitor) throws Exception {
                File parent;
                if (AbstractGetFileContentOperation.this.tmpFile == null) {
                    AbstractGetFileContentOperation.this.tmpFile = AbstractGetFileContentOperation.this.createTempFile();
                }
                if ((parent = AbstractGetFileContentOperation.this.tmpFile.getParentFile()) != null && !parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream stream = new FileOutputStream(AbstractGetFileContentOperation.this.tmpFile);
                try {
                    stream.write(data);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    protected File createTempFile() throws IOException {
        String extension = this.getExtension();
        return SVNTeamPlugin.instance().getTemporaryFile(null, "getfilecontent" + (String)(extension != null && extension.length() > 0 ? "." + extension : ".tmp"));
    }

    protected String getExtension() {
        return "";
    }
}

