/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.management;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RelocateOperation
extends AbstractFileOperation {
    protected String toUrl;

    public RelocateOperation(File[] folders, String toUrl) {
        super("Operation_RelocateFile", SVNMessages.class, folders);
        this.toUrl = toUrl;
    }

    public RelocateOperation(IFileProvider provider, String toUrl) {
        super("Operation_RelocateFile", SVNMessages.class, provider);
        this.toUrl = toUrl;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = FileUtility.shrinkChildNodes(this.operableData(), true);
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(current, false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> {
                String path = current.getAbsolutePath();
                this.writeToConsole(0, "svn switch --relocate \"" + remote.getUrl() + "\" \"" + this.toUrl + "\" \"" + FileUtility.normalizePath(path) + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.relocate(SVNUtility.encodeURL(remote.getUrl()), SVNUtility.encodeURL(this.toUrl), path, SVNDepth.INFINITY, new SVNProgressMonitor(this, monitor1, null));
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

