/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.AbstractGetFileContentOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.core.operation.local.GetLocalFileContentOperation;
import org.eclipse.team.svn.core.operation.local.IExecutable;
import org.eclipse.team.svn.core.operation.remote.GetFileContentOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.osgi.framework.Bundle;

public class RunExternalCompareOperation
extends CompositeOperation
implements IExecutable {
    public static final String DOC_SCRIPT = "diff-doc.vbs";
    public static final String DOCX_SCRIPT = "diff-doc.vbs";
    public static final String XLS_SCRIPT = "diff-xls.vbs";
    public static final String XLSX_SCRIPT = "diff-xls.vbs";
    public static final String PPT_SCRIPT = "diff-ppt.vbs";
    public static final String PPTX_SCRIPT = "diff-ppt.vbs";
    public static final String ODT_SCRIPT = "diff-odX.vbs";
    public static final String ODS_SCRIPT = "diff-odX.vbs";
    protected ExternalCompareOperation externalCompareOperation;

    @Override
    public boolean isExecuted() {
        return this.externalCompareOperation.isExecuted();
    }

    public RunExternalCompareOperation(ILocalResource local, IRepositoryResource remote, DiffViewerSettings diffSettings) {
        super("Operation_ExternalCompare", SVNMessages.class);
        DetectExternalCompareOperation detectOperation = new DetectExternalCompareOperation(local.getResource(), diffSettings);
        this.add(detectOperation);
        this.externalCompareOperation = new ExternalCompareOperation(local, remote, detectOperation);
        this.add(this.externalCompareOperation, new IActionOperation[]{detectOperation});
    }

    public static File getScriptFile(String fileName, IProgressMonitor monitor) throws IOException {
        File stateArea = SVNTeamPlugin.instance().getStateLocation().toFile();
        File scriptFile = new File(stateArea, fileName);
        if (!scriptFile.exists()) {
            URL scriptUrl = FileLocator.find((Bundle)SVNTeamPlugin.instance().getBundle(), (IPath)new Path("/resources/" + fileName), null);
            if (scriptUrl == null) {
                throw new RuntimeException("Failed to locate script file. File name: " + fileName);
            }
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = scriptUrl.openStream();
                out = new FileOutputStream(scriptFile);
                int loaded = 0;
                byte[] buf = new byte[2048];
                while ((loaded = in.read(buf)) > 0 && !monitor.isCanceled()) {
                    out.write(buf, 0, loaded);
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return scriptFile;
    }

    public static class DefaultExternalProgramParametersProvider
    implements IExternalProgramParametersProvider {
        protected DiffViewerSettings.ExternalProgramParameters externalProgramParameters;

        public DefaultExternalProgramParametersProvider(DiffViewerSettings.ExternalProgramParameters externalProgramParameters) {
            this.externalProgramParameters = externalProgramParameters;
        }

        @Override
        public DiffViewerSettings.ExternalProgramParameters getExternalProgramParameters() {
            return this.externalProgramParameters;
        }
    }

    public static class DetectExternalCompareOperation
    extends AbstractActionOperation
    implements IExternalProgramParametersProvider {
        protected IResource resource;
        protected IRepositoryResource repositoryResource;
        protected IRepositoryResourceProvider provider;
        protected DiffViewerSettings diffSettings;
        protected DetectExternalCompareOperationHelper helper;

        protected DetectExternalCompareOperation(DiffViewerSettings diffSettings) {
            super("Operation_DetectExternalCompare", SVNMessages.class);
            this.diffSettings = diffSettings;
        }

        public DetectExternalCompareOperation(IResource resource, DiffViewerSettings diffSettings) {
            this(diffSettings);
            this.resource = resource;
        }

        public DetectExternalCompareOperation(IRepositoryResource repositoryResource, DiffViewerSettings diffSettings) {
            this(diffSettings);
            this.repositoryResource = repositoryResource;
        }

        public DetectExternalCompareOperation(IRepositoryResourceProvider provider, DiffViewerSettings diffSettings) {
            this(diffSettings);
            this.provider = provider;
        }

        @Override
        protected void runImpl(IProgressMonitor monitor) throws Exception {
            if (this.resource != null) {
                this.helper = new DetectExternalCompareOperationHelper(this.resource, this.diffSettings, true);
            } else {
                IRepositoryResource reposResource = this.provider != null ? this.provider.getRepositoryResources()[0] : this.repositoryResource;
                this.helper = new DetectExternalCompareOperationHelper(reposResource, this.diffSettings, true);
            }
            this.helper.execute(monitor);
        }

        @Override
        public DiffViewerSettings.ExternalProgramParameters getExternalProgramParameters() {
            return this.helper.getExternalProgramParameters();
        }
    }

    public static class DetectExternalCompareOperationHelper {
        protected DiffViewerSettings diffSettings;
        protected IRepositoryResource repositoryResource;
        protected IResource resource;
        protected boolean isDiff;
        protected DiffViewerSettings.ExternalProgramParameters externalProgramParams;

        public DetectExternalCompareOperationHelper(IResource resource, DiffViewerSettings diffSettings, boolean isDiff) {
            this.diffSettings = diffSettings;
            this.resource = resource;
            this.isDiff = isDiff;
        }

        public DetectExternalCompareOperationHelper(IRepositoryResource repositoryResource, DiffViewerSettings diffSettings, boolean isDiff) {
            this.diffSettings = diffSettings;
            this.repositoryResource = repositoryResource;
            this.isDiff = isDiff;
        }

        public void execute(IProgressMonitor monitor) {
            if (this.resource != null) {
                this.detectWithResource(monitor);
            } else if (this.repositoryResource != null) {
                this.detectWithRepositoryResource(monitor);
            }
            if (this.externalProgramParams != null) {
                String path = null;
                path = this.isDiff ? this.externalProgramParams.diffProgramPath : this.externalProgramParams.mergeProgramPath;
                if (path == null || path.length() == 0) {
                    this.externalProgramParams = null;
                }
            }
        }

        protected void detectWithRepositoryResource(IProgressMonitor monitor) {
            if (this.repositoryResource instanceof IRepositoryFile) {
                IRepositoryFile file = (IRepositoryFile)this.repositoryResource;
                DiffViewerSettings.ResourceSpecificParameterKind specificKind = DiffViewerSettings.getSpecificResourceKind(this.diffSettings, file, monitor);
                if (specificKind != null) {
                    this.externalProgramParams = this.diffSettings.getResourceSpecificParameters((DiffViewerSettings.ResourceSpecificParameterKind)specificKind).params;
                }
                DiffViewerSettings.ResourceSpecificParameters defaultResourceSpecificParameters = null;
                if (this.externalProgramParams == null && (defaultResourceSpecificParameters = this.diffSettings.getDefaultResourceSpecificParameters()) != null) {
                    this.externalProgramParams = defaultResourceSpecificParameters.params;
                }
            }
        }

        protected void detectWithResource(IProgressMonitor monitor) {
            if (this.resource instanceof IFile) {
                IFile file = (IFile)this.resource;
                DiffViewerSettings.ResourceSpecificParameterKind specificKind = DiffViewerSettings.getSpecificResourceKind(this.diffSettings, file, monitor);
                if (specificKind != null) {
                    this.externalProgramParams = this.diffSettings.getResourceSpecificParameters((DiffViewerSettings.ResourceSpecificParameterKind)specificKind).params;
                }
                DiffViewerSettings.ResourceSpecificParameters defaultResourceSpecificParameters = null;
                if (this.externalProgramParams == null && (defaultResourceSpecificParameters = this.diffSettings.getDefaultResourceSpecificParameters()) != null) {
                    this.externalProgramParams = defaultResourceSpecificParameters.params;
                }
            }
        }

        public DiffViewerSettings.ExternalProgramParameters getExternalProgramParameters() {
            return this.externalProgramParams;
        }
    }

    public static class ExternalCompareOperation
    extends CompositeOperation {
        protected IExternalProgramParametersProvider parametersProvider;
        protected DiffViewerSettings.ExternalProgramParameters externalProgramParams;
        protected boolean isExecuted;

        public ExternalCompareOperation(ILocalResource local, IRepositoryResource remote, IExternalProgramParametersProvider parametersProvider) {
            super("Operation_ExternalCompare", SVNMessages.class);
            this.parametersProvider = parametersProvider;
            SVNRevision revision = remote.getSelectedRevision();
            boolean fetchRemote = revision.getKind() == SVNRevision.Kind.HEAD || revision.getKind() == SVNRevision.Kind.NUMBER;
            final GetLocalFileContentOperation oldFileGetOp = new GetLocalFileContentOperation(local.getResource(), SVNRevision.Kind.BASE);
            this.add(oldFileGetOp);
            final GetLocalFileContentOperation currentFileGetOp = new GetLocalFileContentOperation(local.getResource(), SVNRevision.Kind.WORKING);
            this.add(currentFileGetOp, new IActionOperation[]{oldFileGetOp});
            final AbstractGetFileContentOperation newFileGetOp = fetchRemote ? new GetFileContentOperation(remote) : new GetLocalFileContentOperation(local.getResource(), SVNRevision.Kind.BASE);
            this.add(newFileGetOp, new IActionOperation[]{currentFileGetOp});
            this.add(new AbstractActionOperation("Operation_ExternalCompare", SVNMessages.class){

                @Override
                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    ExternalCompareOperationHelper externalRunHelper = new ExternalCompareOperationHelper(oldFileGetOp.getTemporaryPath(), currentFileGetOp.getTemporaryPath(), newFileGetOp.getTemporaryPath(), externalProgramParams);
                    externalRunHelper.execute(monitor);
                }
            }, new IActionOperation[]{oldFileGetOp, currentFileGetOp, newFileGetOp});
        }

        @Override
        protected void runImpl(IProgressMonitor monitor) throws Exception {
            this.externalProgramParams = this.parametersProvider.getExternalProgramParameters();
            if (this.externalProgramParams != null) {
                this.isExecuted = true;
                super.runImpl(monitor);
            } else {
                this.isExecuted = false;
            }
        }

        public boolean isExecuted() {
            return this.isExecuted;
        }
    }

    public static class ExternalCompareOperationHelper {
        protected String baseFile;
        protected String currentFile;
        protected String newFile;
        protected String targetFile;
        protected DiffViewerSettings.ExternalProgramParameters externalProgramParams;
        protected boolean isDiff;

        public ExternalCompareOperationHelper(String baseFile, String currentFile, String newFile, DiffViewerSettings.ExternalProgramParameters externalProgramParams) {
            this(baseFile, currentFile, newFile, currentFile, externalProgramParams, true);
        }

        public ExternalCompareOperationHelper(String baseFile, String currentFile, String newFile, DiffViewerSettings.ExternalProgramParameters externalProgramParams, boolean isDiff) {
            this(baseFile, currentFile, newFile, currentFile, externalProgramParams, isDiff);
        }

        public ExternalCompareOperationHelper(String baseFile, String currentFile, String newFile, String targetFile, DiffViewerSettings.ExternalProgramParameters externalProgramParams) {
            this(baseFile, currentFile, newFile, targetFile, externalProgramParams, true);
        }

        public ExternalCompareOperationHelper(String baseFile, String currentFile, String newFile, String targetFile, DiffViewerSettings.ExternalProgramParameters externalProgramParams, boolean isDiff) {
            this.externalProgramParams = externalProgramParams;
            this.baseFile = baseFile != null ? baseFile : "";
            this.currentFile = currentFile != null ? currentFile : "";
            this.newFile = newFile != null ? newFile : "";
            this.targetFile = targetFile != null ? targetFile : "";
            this.isDiff = isDiff;
        }

        public void execute(IProgressMonitor monitor) throws Exception {
            String programPath = this.isDiff ? this.externalProgramParams.diffProgramPath : this.externalProgramParams.mergeProgramPath;
            String programParameters = this.isDiff ? this.externalProgramParams.diffParamatersString : this.externalProgramParams.mergeParamatersString;
            Object processedCmd = programPath;
            String diffParameters = this.prepareParameters(monitor, programParameters);
            processedCmd = (String)processedCmd + " " + diffParameters;
            Runtime.getRuntime().exec((String)processedCmd);
        }

        protected String prepareParameters(IProgressMonitor monitor, String params) throws IOException {
            String paramaters = params;
            paramaters = paramaters.replace("${base}", this.baseFile);
            paramaters = paramaters.replace("${mine}", this.currentFile);
            paramaters = paramaters.replace("${theirs}", this.newFile);
            if ((paramaters = paramaters.replace("${merged}", this.targetFile)).indexOf("${default-doc-program}") != -1) {
                paramaters = paramaters.replace("${default-doc-program}", RunExternalCompareOperation.getScriptFile("diff-doc.vbs", monitor).getAbsolutePath());
            }
            if (paramaters.indexOf("${default-xls-program}") != -1) {
                paramaters = paramaters.replace("${default-xls-program}", RunExternalCompareOperation.getScriptFile("diff-xls.vbs", monitor).getAbsolutePath());
            }
            if (paramaters.indexOf("${default-ppt-program}") != -1) {
                paramaters = paramaters.replace("${default-ppt-program}", RunExternalCompareOperation.getScriptFile("diff-ppt.vbs", monitor).getAbsolutePath());
            }
            if (paramaters.indexOf("${default-odt-program}") != -1) {
                paramaters = paramaters.replace("${default-odt-program}", RunExternalCompareOperation.getScriptFile("diff-odX.vbs", monitor).getAbsolutePath());
            }
            if (paramaters.indexOf("${default-ods-program}") != -1) {
                paramaters = paramaters.replace("${default-ods-program}", RunExternalCompareOperation.getScriptFile("diff-odX.vbs", monitor).getAbsolutePath());
            }
            return paramaters;
        }
    }

    public static interface IExternalProgramParametersProvider {
        public DiffViewerSettings.ExternalProgramParameters getExternalProgramParameters();
    }
}

