/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.properties.PredefinedProperty;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositePropertiesVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.ExistingResourceVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.PropertyNameVerifier;
import org.eclipse.team.svn.ui.verifier.PropertyVerifier;

public abstract class AbstractPropertyEditPanel
extends AbstractDialogPanel {
    protected SVNProperty[] source;
    protected HashMap<String, String> alreadyExistent;
    protected Combo nameField;
    protected Text valueField;
    protected Text fileField;
    protected Text descriptionField;
    protected boolean fileSelected;
    protected String propertyName;
    protected String propertyValue;
    protected String propertyFile;
    protected List<PredefinedProperty> predefinedProperties;
    protected HashMap<String, AbstractFormattedVerifier> verifiers;

    public AbstractPropertyEditPanel(SVNProperty[] propertyData, String dialogTitle, String dialogDescription) {
        if (propertyData != null) {
            this.propertyName = propertyData[0].name;
            this.propertyValue = propertyData[0].value;
        }
        this.verifiers = new HashMap();
        this.dialogTitle = dialogTitle;
        this.dialogDescription = dialogDescription;
        this.source = propertyData;
        this.fileSelected = false;
        this.alreadyExistent = new HashMap();
        if (propertyData != null) {
            SVNProperty[] sVNPropertyArray = propertyData;
            int n = propertyData.length;
            int n2 = 0;
            while (n2 < n) {
                SVNProperty current = sVNPropertyArray[n2];
                this.alreadyExistent.put(current.name, current.value);
                ++n2;
            }
        }
    }

    public boolean isFileSelected() {
        return this.fileSelected;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyToEdit(SVNProperty propertyToEdit) {
        if (propertyToEdit != null) {
            this.propertyName = propertyToEdit.name;
            this.propertyValue = propertyToEdit.value;
        } else {
            this.propertyValue = "";
            this.propertyName = "";
        }
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.AbstractPropertyEditPanel_Name);
        this.nameField = new Combo(composite, 0);
        GridData data = new GridData(768);
        this.nameField.setLayoutData((Object)data);
        this.nameField.setVisibleItemCount(10);
        this.nameField.setItems(this.getPropertyNames(this.predefinedProperties));
        this.nameField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected = AbstractPropertyEditPanel.this.nameField.getItem(AbstractPropertyEditPanel.this.nameField.getSelectionIndex());
                String value = AbstractPropertyEditPanel.this.alreadyExistent.get(selected);
                if (value != null) {
                    AbstractPropertyEditPanel.this.valueField.setText(value);
                } else {
                    PredefinedProperty prop = AbstractPropertyEditPanel.this.getPredefinedProperty(selected);
                    if (prop != null) {
                        AbstractPropertyEditPanel.this.valueField.setText(prop.value);
                    }
                }
                AbstractPropertyEditPanel.this.descriptionField.setText(AbstractPropertyEditPanel.this.getDescriptionText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Listener nameFieldListener = event -> {
            PredefinedProperty prop = this.getPredefinedProperty(this.nameField.getText());
            if (prop != null) {
                this.valueField.setText(prop.value);
            }
            this.descriptionField.setText(this.getDescriptionText());
        };
        this.nameField.addListener(13, nameFieldListener);
        this.nameField.addListener(24, nameFieldListener);
        Composite descriptionComposite = new Composite(composite, 2048);
        data = new GridData(768);
        descriptionComposite.setLayoutData((Object)data);
        GridLayout descriptionLayout = new GridLayout();
        descriptionLayout.horizontalSpacing = 5;
        descriptionLayout.numColumns = 2;
        descriptionComposite.setLayout((Layout)descriptionLayout);
        Label bulb = new Label(descriptionComposite, 0);
        bulb.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/dialogs/bulb.png").createImage());
        data = new GridData();
        data.verticalAlignment = 128;
        bulb.setLayoutData((Object)data);
        this.descriptionField = new Text(descriptionComposite, 578);
        data = new GridData(768);
        data.verticalAlignment = 128;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 100;
        this.descriptionField.setLayoutData((Object)data);
        this.descriptionField.setText(this.getDescriptionText());
        this.descriptionField.setBackground(this.nameField.getBackground());
        descriptionComposite.setBackground(this.nameField.getBackground());
        bulb.setBackground(this.nameField.getBackground());
        this.descriptionField.setEditable(false);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNUIMessages.AbstractPropertyEditPanel_Name_Verifier;
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new PropertyNameVerifier(name));
        this.attachTo((Control)this.nameField, verifier);
        final Button editManual = new Button(composite, 16);
        this.valueField = new Text(composite, 2818);
        CompositePropertiesVerifier valueVerifier = new CompositePropertiesVerifier(this.nameField, this.verifiers);
        this.attachTo((Control)this.valueField, new AbstractVerifierProxy(valueVerifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return editManual.getSelection();
            }
        });
        data = new GridData();
        editManual.setLayoutData((Object)data);
        editManual.setText(SVNUIMessages.AbstractPropertyEditPanel_EnterValue);
        editManual.addListener(13, event -> {
            Button button = (Button)event.widget;
            this.valueField.setEnabled(button.getSelection());
            this.fileSelected = false;
            this.validateContent();
        });
        editManual.setSelection(true);
        data = new GridData(1808);
        data.heightHint = 100;
        this.valueField.setLayoutData((Object)data);
        this.valueField.selectAll();
        this.valueField.setEnabled(true);
        final Button loadFromFile = new Button(composite, 16);
        Composite subComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        subComposite.setLayout((Layout)layout);
        data = new GridData(768);
        subComposite.setLayoutData((Object)data);
        this.fileField = new Text(subComposite, 2052);
        Button browse = new Button(subComposite, 8);
        browse.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browse);
        browse.setLayoutData((Object)data);
        browse.setEnabled(false);
        browse.addListener(13, event -> {
            FileDialog fileDialog = new FileDialog(this.manager.getShell(), 4096);
            String res = fileDialog.open();
            if (res != null) {
                this.fileField.setText(res);
                this.validateContent();
            }
        });
        data = new GridData();
        loadFromFile.setLayoutData((Object)data);
        loadFromFile.setText(SVNUIMessages.AbstractPropertyEditPanel_LoadValue);
        loadFromFile.addListener(13, event -> {
            Button button2 = (Button)event.widget;
            this.fileField.setEnabled(button2.getSelection());
            browse.setEnabled(button2.getSelection());
            this.fileSelected = true;
            this.validateContent();
        });
        data = new GridData(768);
        this.fileField.setLayoutData((Object)data);
        this.fileField.setEnabled(false);
        this.attachTo((Control)this.fileField, new AbstractVerifierProxy(new ExistingResourceVerifier(SVNUIMessages.AbstractPropertyEditPanel_File_Verifier, true)){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return loadFromFile.getSelection();
            }
        });
        if (this.source != null && this.source.length > 0) {
            this.nameField.setText(this.propertyName);
            this.valueField.setText(this.propertyValue);
        }
        this.nameField.setFocus();
    }

    protected List<PredefinedProperty> getPredefinedProperties() {
        ArrayList<PredefinedProperty> properties = new ArrayList<PredefinedProperty>();
        for (PredefinedProperty property : CoreExtensionsManager.instance().getPredefinedPropertySet().getPredefinedProperties()) {
            if (!this.isPropertyAccepted(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    protected void fillVerifiersMap() {
        this.predefinedProperties = this.getPredefinedProperties();
        IRepositoryResource base = this.getRepostioryResource();
        for (PredefinedProperty current : this.predefinedProperties) {
            this.verifiers.put(current.name, new PropertyVerifier("EditPropertiesInputField", "".equals(current.validationRegexp) ? null : current.validationRegexp, current.name, base));
        }
    }

    protected abstract boolean isPropertyAccepted(PredefinedProperty var1);

    protected abstract IRepositoryResource getRepostioryResource();

    protected String[] getPropertyNames(List<PredefinedProperty> predefinedProperties) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<PredefinedProperty> it = predefinedProperties.iterator();
        while (it.hasNext()) {
            names.add(it.next().name);
        }
        return names.toArray(new String[names.size()]);
    }

    protected String getDescriptionText() {
        String propName = this.nameField.getText();
        PredefinedProperty prop = this.getPredefinedProperty(propName);
        if (prop != null) {
            return prop.description != null && prop.description.trim().length() > 0 ? prop.description : SVNUIMessages.AbstractPropertyEditPanel_NoDescription;
        }
        return SVNUIMessages.AbstractPropertyEditPanel_UserDefined;
    }

    protected PredefinedProperty getPredefinedProperty(String name) {
        int idx = this.predefinedProperties.indexOf(new PredefinedProperty(name));
        if (idx >= 0) {
            return this.predefinedProperties.get(idx);
        }
        return null;
    }

    @Override
    protected void saveChangesImpl() {
        this.propertyName = this.nameField.getText();
        this.propertyValue = this.valueField.getText();
        this.propertyFile = this.fileField.getText();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    public String getDefaultMessage() {
        return SVNUIMessages.AbstractPropertyEditPanel_DefaultMessage;
    }
}

