/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cs extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "acrejsk\u00fd standardn\u00ed \u010das",
               "",
               "acrejsk\u00fd letn\u00ed \u010das",
               "",
               "acrejsk\u00fd \u010das",
               "",
            };
        final String[] Apia = new String[] {
               "apijsk\u00fd standardn\u00ed \u010das",
               "",
               "apijsk\u00fd letn\u00ed \u010das",
               "",
               "apijsk\u00fd \u010das",
               "",
            };
        final String[] Cook = new String[] {
               "standardn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "",
               "letn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "",
               "\u010das Cookov\u00fdch ostrov\u016f",
               "",
            };
        final String[] Cuba = new String[] {
               "kub\u00e1nsk\u00fd standardn\u00ed \u010das",
               "CST",
               "kub\u00e1nsk\u00fd letn\u00ed \u010das",
               "CDT",
               "kub\u00e1nsk\u00fd \u010das",
               "CT",
            };
        final String[] Fiji = new String[] {
               "fid\u017eijsk\u00fd standardn\u00ed \u010das",
               "",
               "fid\u017eijsk\u00fd letn\u00ed \u010das",
               "",
               "fid\u017eijsk\u00fd \u010das",
               "",
            };
        final String[] Gulf = new String[] {
               "standardn\u00ed \u010das Persk\u00e9ho z\u00e1livu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hovdsk\u00fd standardn\u00ed \u010das",
               "",
               "hovdsk\u00fd letn\u00ed \u010das",
               "",
               "hovdsk\u00fd \u010das",
               "",
            };
        final String[] Iran = new String[] {
               "\u00edr\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "\u00edr\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "\u00edr\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Niue = new String[] {
               "niuejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omsk\u00fd standardn\u00ed \u010das",
               "",
               "omsk\u00fd letn\u00ed \u010das",
               "",
               "omsk\u00fd \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "peru\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "peru\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "peru\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Truk = new String[] {
               "chuuksk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010das ostrova Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "chilsk\u00fd standardn\u00ed \u010das",
               "",
               "chilsk\u00fd letn\u00ed \u010das",
               "",
               "chilsk\u00fd \u010das",
               "",
            };
        final String[] China = new String[] {
               "\u010d\u00ednsk\u00fd standardn\u00ed \u010das",
               "CST",
               "\u010d\u00ednsk\u00fd letn\u00ed \u010das",
               "CDT",
               "\u010d\u00ednsk\u00fd \u010das",
               "CT",
            };
        final String[] Cocos = new String[] {
               "\u010das Kokosov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u010das Davisovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indick\u00fd \u010das",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japonsk\u00fd standardn\u00ed \u010das",
               "JST",
               "japonsk\u00fd letn\u00ed \u010das",
               "JDT",
               "japonsk\u00fd \u010das",
               "JT",
            };
        final String[] Korea = new String[] {
               "korejsk\u00fd standardn\u00ed \u010das",
               "KST",
               "korejsk\u00fd letn\u00ed \u010das",
               "KST",
               "korejsk\u00fd \u010das",
               "KST",
            };
        final String[] Nauru = new String[] {
               "naursk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1lsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samojsk\u00fd standardn\u00ed \u010das",
               "SST",
               "samojsk\u00fd letn\u00ed \u010das",
               "SST",
               "samojsk\u00fd \u010das",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u010das stanice \u0160\u00f3wa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ton\u017esk\u00fd standardn\u00ed \u010das",
               "",
               "ton\u017esk\u00fd letn\u00ed \u010das",
               "",
               "ton\u017esk\u00fd \u010das",
               "",
            };
        final String[] Yukon = new String[] {
               "yukonsk\u00fd \u010das",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "alja\u0161sk\u00fd standardn\u00ed \u010das",
               "AKST",
               "alja\u0161sk\u00fd letn\u00ed \u010das",
               "AKDT",
               "alja\u0161sk\u00fd \u010das",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "amazonsk\u00fd standardn\u00ed \u010das",
               "",
               "amazonsk\u00fd letn\u00ed \u010das",
               "",
               "amazonsk\u00fd \u010das",
               "",
            };
        final String[] Anadyr = new String[] {
               "anadyrsk\u00fd standardn\u00ed \u010das",
               "",
               "anadyrsk\u00fd letn\u00ed \u010das",
               "",
               "anadyrsk\u00fd \u010das",
               "",
            };
        final String[] Azores = new String[] {
               "azorsk\u00fd standardn\u00ed \u010das",
               "",
               "azorsk\u00fd letn\u00ed \u010das",
               "",
               "azorsk\u00fd \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "bh\u00fat\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "brunejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "standardn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "",
               "letn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "",
               "\u010das Velikono\u010dn\u00edho ostrova",
               "",
            };
        final String[] Guyana = new String[] {
               "guyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "izraelsk\u00fd standardn\u00ed \u010das",
               "IST",
               "izraelsk\u00fd letn\u00ed \u010das",
               "IDT",
               "izraelsk\u00fd \u010das",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "kosrajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "\u010das Mawsonovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moskevsk\u00fd standardn\u00ed \u010das",
               "MSK",
               "moskevsk\u00fd letn\u00ed \u010das",
               "MSK",
               "moskevsk\u00fd \u010das",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ponapsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "samarsk\u00fd standardn\u00ed \u010das",
               "",
               "samarsk\u00fd letn\u00ed \u010das",
               "",
               "samarsk\u00fd \u010das",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "tchajpejsk\u00fd standardn\u00ed \u010das",
               "CST",
               "tchajpejsk\u00fd letn\u00ed \u010das",
               "CDT",
               "tchajpejsk\u00fd \u010das",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "\u010das stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010das ostrov\u016f Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabsk\u00fd standardn\u00ed \u010das",
               "",
               "arabsk\u00fd letn\u00ed \u010das",
               "",
               "arabsk\u00fd \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "arm\u00e9nsk\u00fd standardn\u00ed \u010das",
               "",
               "arm\u00e9nsk\u00fd letn\u00ed \u010das",
               "",
               "arm\u00e9nsk\u00fd \u010das",
               "",
            };
        final String[] Bolivia = new String[] {
               "bolivijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathamsk\u00fd standardn\u00ed \u010das",
               "",
               "chathamsk\u00fd letn\u00ed \u010das",
               "",
               "chathamsk\u00fd \u010das",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinovan\u00fd sv\u011btov\u00fd \u010das",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekv\u00e1dorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambiersk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "gruz\u00ednsk\u00fd standardn\u00ed \u010das",
               "",
               "gruz\u00ednsk\u00fd letn\u00ed \u010das",
               "",
               "gruz\u00ednsk\u00fd \u010das",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutsk\u00fd standardn\u00ed \u010das",
               "",
               "irkutsk\u00fd letn\u00ed \u010das",
               "",
               "irkutsk\u00fd \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "magadansk\u00fd standardn\u00ed \u010das",
               "",
               "magadansk\u00fd letn\u00ed \u010das",
               "",
               "magadansk\u00fd \u010das",
               "",
            };
        final String[] Myanmar = new String[] {
               "myanmarsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolksk\u00fd standardn\u00ed \u010das",
               "",
               "norfolksk\u00fd letn\u00ed \u010das",
               "",
               "norfolksk\u00fd \u010das",
               "",
            };
        final String[] Noronha = new String[] {
               "standardn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "",
               "letn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "",
               "\u010das souostrov\u00ed Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unionsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u010das Rotherovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u010das \u0160alamounov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguaysk\u00fd standardn\u00ed \u010das",
               "",
               "uruguaysk\u00fd letn\u00ed \u010das",
               "",
               "uruguaysk\u00fd \u010das",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatsk\u00fd standardn\u00ed \u010das",
               "",
               "vanuatsk\u00fd letn\u00ed \u010das",
               "",
               "vanuatsk\u00fd \u010das",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutsk\u00fd standardn\u00ed \u010das",
               "",
               "jakutsk\u00fd letn\u00ed \u010das",
               "",
               "jakutsk\u00fd \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantick\u00fd standardn\u00ed \u010das",
               "AST",
               "atlantick\u00fd letn\u00ed \u010das",
               "ADT",
               "atlantick\u00fd \u010das",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "brasilijsk\u00fd standardn\u00ed \u010das",
               "",
               "brasilijsk\u00fd letn\u00ed \u010das",
               "",
               "brasilijsk\u00fd \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorrsk\u00fd \u010das",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolumbijsk\u00fd standardn\u00ed \u010das",
               "",
               "kolumbijsk\u00fd letn\u00ed \u010das",
               "",
               "kolumbijsk\u00fd \u010das",
               "",
            };
        final String[] Falkland = new String[] {
               "falklandsk\u00fd standardn\u00ed \u010das",
               "",
               "falklandsk\u00fd letn\u00ed \u010das",
               "",
               "falklandsk\u00fd \u010das",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maledivsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ul\u00e1nb\u00e1tarsk\u00fd standardn\u00ed \u010das",
               "",
               "ul\u00e1nb\u00e1tarsk\u00fd letn\u00ed \u010das",
               "",
               "ul\u00e1nb\u00e1tarsk\u00fd \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "p\u00e1kist\u00e1nsk\u00fd standardn\u00ed \u010das",
               "PKT",
               "p\u00e1kist\u00e1nsk\u00fd letn\u00ed \u010das",
               "PKST",
               "p\u00e1kist\u00e1nsk\u00fd \u010das",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paraguaysk\u00fd standardn\u00ed \u010das",
               "",
               "paraguaysk\u00fd letn\u00ed \u010das",
               "",
               "paraguaysk\u00fd \u010das",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u010das Pitcairnov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "sachalinsk\u00fd standardn\u00ed \u010das",
               "",
               "sachalinsk\u00fd letn\u00ed \u010das",
               "",
               "sachalinsk\u00fd \u010das",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argentinsk\u00fd standardn\u00ed \u010das",
               "",
               "argentinsk\u00fd letn\u00ed \u010das",
               "",
               "argentinsk\u00fd \u010das",
               "",
            };
        final String[] Christmas = new String[] {
               "\u010das V\u00e1no\u010dn\u00edho ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galap\u00e1\u017esk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkongsk\u00fd standardn\u00ed \u010das",
               "HKT",
               "hongkongsk\u00fd letn\u00ed \u010das",
               "HKST",
               "hongkongsk\u00fd \u010das",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indo\u010d\u00ednsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "petropavlovsko-kam\u010datsk\u00fd standardn\u00ed \u010das",
               "",
               "petropavlovsko-kam\u010datsk\u00fd letn\u00ed \u010das",
               "",
               "petropavlovsko-kam\u010datsk\u00fd \u010das",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kyrgyzsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "standardn\u00ed \u010das ostrova lorda Howa",
               "",
               "letn\u00ed \u010das ostrova lorda Howa",
               "",
               "\u010das ostrova lorda Howa",
               "",
            };
        final String[] Marquesas = new String[] {
               "mark\u00e9zsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "mauricijsk\u00fd standardn\u00ed \u010das",
               "",
               "mauricijsk\u00fd letn\u00ed \u010das",
               "",
               "mauricijsk\u00fd \u010das",
               "",
            };
        final String[] Singapore = new String[] {
               "singapursk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "volgogradsk\u00fd standardn\u00ed \u010das",
               "MSK",
               "volgogradsk\u00fd letn\u00ed \u010das",
               "MSK",
               "volgogradsk\u00fd \u010das",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "\u00e1zerb\u00e1jd\u017e\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "\u00e1zerb\u00e1jd\u017e\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "\u00e1zerb\u00e1jd\u017e\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "banglad\u00e9\u0161sk\u00fd standardn\u00ed \u010das",
               "",
               "banglad\u00e9\u0161sk\u00fd letn\u00ed \u010das",
               "",
               "banglad\u00e9\u0161sk\u00fd \u010das",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdsk\u00fd standardn\u00ed \u010das",
               "",
               "kapverdsk\u00fd letn\u00ed \u010das",
               "",
               "kapverdsk\u00fd \u010das",
               "",
            };
        final String[] East_Timor = new String[] {
               "v\u00fdchodotimorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "t\u00e1d\u017eick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbeck\u00fd standardn\u00ed \u010das",
               "",
               "uzbeck\u00fd letn\u00ed \u010das",
               "",
               "uzbeck\u00fd \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afgh\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsk\u00fd standardn\u00ed \u010das",
               "",
               "krasnojarsk\u00fd letn\u00ed \u010das",
               "",
               "krasnojarsk\u00fd \u010das",
               "",
            };
        final String[] New_Zealand = new String[] {
               "novoz\u00e9landsk\u00fd standardn\u00ed \u010das",
               "NZST",
               "novoz\u00e9landsk\u00fd letn\u00ed \u010das",
               "NZDT",
               "novoz\u00e9landsk\u00fd \u010das",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsk\u00fd standardn\u00ed \u010das",
               "",
               "novosibirsk\u00fd letn\u00ed \u010das",
               "",
               "novosibirsk\u00fd \u010das",
               "",
            };
        final String[] Philippines = new String[] {
               "filip\u00ednsk\u00fd standardn\u00ed \u010das",
               "PST",
               "filip\u00ednsk\u00fd letn\u00ed \u010das",
               "PDT",
               "filip\u00ednsk\u00fd \u010das",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "vladivostock\u00fd standardn\u00ed \u010das",
               "",
               "vladivostock\u00fd letn\u00ed \u010das",
               "",
               "vladivostock\u00fd \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indickooce\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010das Rovn\u00edkov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsk\u00fd standardn\u00ed \u010das",
               "NST",
               "newfoundlandsk\u00fd letn\u00ed \u010das",
               "NDT",
               "newfoundlandsk\u00fd \u010das",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmensk\u00fd standardn\u00ed \u010das",
               "",
               "turkmensk\u00fd letn\u00ed \u010das",
               "",
               "turkmensk\u00fd \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "francouzskoguyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "novokaledonsk\u00fd standardn\u00ed \u010das",
               "",
               "novokaledonsk\u00fd letn\u00ed \u010das",
               "",
               "novokaledonsk\u00fd \u010das",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u010das Ji\u017en\u00ed Georgie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekat\u011brinbursk\u00fd standardn\u00ed \u010das",
               "",
               "jekat\u011brinbursk\u00fd letn\u00ed \u010das",
               "",
               "jekat\u011brinbursk\u00fd \u010das",
               "",
            };
        final String[] Africa_Central = new String[] {
               "st\u0159edoafrick\u00fd \u010das",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "v\u00fdchodoafrick\u00fd \u010das",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "z\u00e1padoafrick\u00fd standardn\u00ed \u010das",
               "WAT",
               "z\u00e1padoafrick\u00fd letn\u00ed \u010das",
               "WAT",
               "z\u00e1padoafrick\u00fd \u010das",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "\u010das stanice Dumonta d\u2019Urvilla",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "st\u0159edoevropsk\u00fd standardn\u00ed \u010das",
               "SE\u010c",
               "st\u0159edoevropsk\u00fd letn\u00ed \u010das",
               "SEL\u010c",
               "st\u0159edoevropsk\u00fd \u010das",
               "SE\u010c",
            };
        final String[] Europe_Eastern = new String[] {
               "v\u00fdchodoevropsk\u00fd standardn\u00ed \u010das",
               "EET",
               "v\u00fdchodoevropsk\u00fd letn\u00ed \u010das",
               "EEST",
               "v\u00fdchodoevropsk\u00fd \u010das",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "z\u00e1padoevropsk\u00fd standardn\u00ed \u010das",
               "WET",
               "z\u00e1padoevropsk\u00fd letn\u00ed \u010das",
               "WEST",
               "z\u00e1padoevropsk\u00fd \u010das",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "MST",
               "mexick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "MDT",
               "mexick\u00fd pacifick\u00fd \u010das",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "jihoafrick\u00fd \u010das",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "severoamerick\u00fd centr\u00e1ln\u00ed standardn\u00ed \u010das",
               "CST",
               "severoamerick\u00fd centr\u00e1ln\u00ed letn\u00ed \u010das",
               "CDT",
               "severoamerick\u00fd centr\u00e1ln\u00ed \u010das",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "severoamerick\u00fd v\u00fdchodn\u00ed standardn\u00ed \u010das",
               "EST",
               "severoamerick\u00fd v\u00fdchodn\u00ed letn\u00ed \u010das",
               "EDT",
               "severoamerick\u00fd v\u00fdchodn\u00ed \u010das",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "severoamerick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "PST",
               "severoamerick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "PDT",
               "severoamerick\u00fd pacifick\u00fd \u010das",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u010das Francouzsk\u00fdch ji\u017en\u00edch a antarktick\u00fdch \u00fazem\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010das Gilbertov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsk\u00fd standardn\u00ed \u010das",
               "HST",
               "havajsko-aleutsk\u00fd letn\u00ed \u010das",
               "HDT",
               "havajsko-aleutsk\u00fd \u010das",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010das F\u00e9nixov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "pierre-miquelonsk\u00fd standardn\u00ed \u010das",
               "",
               "pierre-miquelonsk\u00fd letn\u00ed \u010das",
               "",
               "pierre-miquelonsk\u00fd \u010das",
               "",
            };
        final String[] America_Mountain = new String[] {
               "severoamerick\u00fd horsk\u00fd standardn\u00ed \u010das",
               "MST",
               "severoamerick\u00fd horsk\u00fd letn\u00ed \u010das",
               "MDT",
               "severoamerick\u00fd horsk\u00fd \u010das",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010das Marshallov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010das Papuy-Nov\u00e9 Guiney",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "st\u0159edoaustralsk\u00fd standardn\u00ed \u010das",
               "ACST",
               "st\u0159edoaustralsk\u00fd letn\u00ed \u010das",
               "ACDT",
               "st\u0159edoaustralsk\u00fd \u010das",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "v\u00fdchodoaustralsk\u00fd standardn\u00ed \u010das",
               "AEST",
               "v\u00fdchodoaustralsk\u00fd letn\u00ed \u010das",
               "AEDT",
               "v\u00fdchodoaustralsk\u00fd \u010das",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "z\u00e1padoaustralsk\u00fd standardn\u00ed \u010das",
               "AWST",
               "z\u00e1padoaustralsk\u00fd letn\u00ed \u010das",
               "AWDT",
               "z\u00e1padoaustralsk\u00fd \u010das",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "st\u0159edoindon\u00e9sk\u00fd \u010das",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "v\u00fdchodoindon\u00e9sk\u00fd \u010das",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "z\u00e1padoindon\u00e9sk\u00fd \u010das",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "z\u00e1padokazachst\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "st\u0159edoz\u00e1padn\u00ed australsk\u00fd standardn\u00ed \u010das",
               "",
               "st\u0159edoz\u00e1padn\u00ed australsk\u00fd letn\u00ed \u010das",
               "",
               "st\u0159edoz\u00e1padn\u00ed australsk\u00fd \u010das",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00ed \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinovan\u00fd sv\u011btov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "irsk\u00fd letn\u00ed \u010das",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinovan\u00fd sv\u011btov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinovan\u00fd sv\u011btov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00ed \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinovan\u00fd sv\u011btov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii",
                new String[] {
                    "havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Universal",
                new String[] {
                    "koordinovan\u00fd sv\u011btov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinovan\u00fd sv\u011btov\u00fd \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "irsk\u00fd letn\u00ed \u010das",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00ed \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00ed \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10",
                new String[] {
                    "havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00ed \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00ed \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston",
                new String[] {
                    "havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "GMT",
                    "britsk\u00fd letn\u00ed \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Dh\u00e1ka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Kabul", "K\u00e1bul" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "timezone.excity.Asia/Saigon", "Ho \u010ci Minovo m\u011bsto" },
            { "timezone.excity.Asia/Taipei", "Tchaj-pej" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "nezn\u00e1m\u00e9 m\u011bsto" },
            { "timezone.excity.Europe/Kiev", "Kyjev" },
            { "timezone.excity.Europe/Rome", "\u0158\u00edm" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "K\u00e1hira" },
            { "timezone.excity.Asia/Baghdad", "Bagd\u00e1d" },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1\u010d\u00ed" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.Asia/Nicosia", "Nik\u00f3sie" },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Thimphu", "Thimb\u00fa" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "Pa\u0159\u00ed\u017e" },
            { "timezone.excity.Europe/Sofia", "Sofie" },
            { "timezone.excity.Indian/Cocos", "Kokosov\u00e9 ostrovy" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Pacific/Truk", "Chuuksk\u00e9 ostrovy" },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161chabad" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "timezone.excity.Asia/Damascus", "Dama\u0161ek" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Katmandu", "K\u00e1thm\u00e1nd\u00fa" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160anghaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Europe/Athens", "Ath\u00e9ny" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/London", "Lond\u00fdn" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "V\u00edde\u0148" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1h\u0159eb" },
            { "timezone.excity.Europe/Zurich", "Curych" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abid\u017ean" },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u00edr" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Kajmansk\u00e9 ostrovy" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzal\u00e9m" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pyongyang", "Pchjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Pacific/Easter", "Velikono\u010dn\u00ed ostrov" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/Khartoum", "Chart\u00fam" },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017eamena" },
            { "timezone.excity.Africa/Sao_Tome", "Svat\u00fd Tom\u00e1\u0161" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnompenh" },
            { "timezone.excity.Atlantic/Azores", "Azorsk\u00e9 ostrovy" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1rsk\u00e9 ostrovy" },
            { "timezone.excity.Atlantic/Faeroe", "Faersk\u00e9 ostrovy" },
            { "timezone.excity.Europe/Belgrade", "B\u011blehrad" },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "timezone.excity.Europe/Budapest", "Budape\u0161\u0165" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161in\u011bv" },
            { "timezone.excity.Europe/Helsinki", "Helsinky" },
            { "timezone.excity.Indian/Maldives", "Maledivy" },
            { "timezone.excity.Pacific/Chatham", "Chathamsk\u00e9 ostrovy" },
            { "timezone.excity.Pacific/Gambier", "Gambierovy ostrovy" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161u" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Kitts", "Svat\u00fd Kry\u0161tof" },
            { "timezone.excity.America/St_Lucia", "Svat\u00e1 Lucie" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1nb\u00e1tar" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Europe/Astrakhan", "Astracha\u0148" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161\u0165" },
            { "timezone.excity.Europe/Ljubljana", "Lubla\u0148" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "V\u00e1no\u010dn\u00ed ostrov" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelenovy ostrovy" },
            { "timezone.excity.Indian/Mauritius", "Mauricius" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairnovy ostrovy" },
            { "timezone.excity.Africa/Nouakchott", "Nuak\u0161ott" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Svat\u00fd Tom\u00e1\u0161 (Karibik)" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzn\u011bck" },
            { "timezone.excity.Europe/Copenhagen", "Koda\u0148" },
            { "timezone.excity.Europe/Luxembourg", "Lucemburk" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galap\u00e1gy" },
            { "timezone.excity.Pacific/Marquesas", "Mark\u00e9zy" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/St_Vincent", "Svat\u00fd Vincenc" },
            { "timezone.excity.Asia/Srednekolymsk", "Sredn\u011bkolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekat\u011brinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Svat\u00e1 Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrov Man" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapverdy" },
            { "timezone.excity.America/St_Barthelemy", "Svat\u00fd Bartolom\u011bj" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Ji\u017en\u00ed Georgie" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severn\u00ed Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severn\u00ed Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severn\u00ed Dakota" },
        };
        return data;
    }
}
