/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.io.File;
import jdk.test.lib.StringArrayUtils;
import jdk.test.lib.cds.CDSTestUtils;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public abstract class CDSAppTester {
    private final String name;
    private final String classListFile;
    private final String classListFileLog;
    private final String staticArchiveFile;
    private final String staticArchiveFileLog;
    private final String dynamicArchiveFile;
    private final String dynamicArchiveFileLog;
    private final String productionRunLog;
    private Workflow workflow;

    public CDSAppTester(String name) {
        this.name = name;
        this.classListFile = this.name() + ".classlist";
        this.classListFileLog = this.classListFile + ".log";
        this.staticArchiveFile = this.name() + ".static.jsa";
        this.staticArchiveFileLog = this.staticArchiveFile + ".log";
        this.dynamicArchiveFile = this.name() + ".dynamic.jsa";
        this.dynamicArchiveFileLog = this.dynamicArchiveFile + ".log";
        this.productionRunLog = this.name() + ".production.log";
    }

    public final String name() {
        return this.name;
    }

    public String[] vmArgs(RunMode runMode) {
        return new String[0];
    }

    public String classpath(RunMode runMode) {
        return null;
    }

    public abstract String[] appCommandLine(RunMode var1);

    public void checkExecution(OutputAnalyzer out, RunMode runMode) throws Exception {
    }

    public final boolean isStaticWorkflow() {
        return this.workflow == Workflow.STATIC;
    }

    public final boolean isDynamicWorkflow() {
        return this.workflow == Workflow.DYNAMIC;
    }

    private String logToFile(String logFile, String ... logTags) {
        StringBuilder sb = new StringBuilder("-Xlog:");
        String prefix = "";
        for (String tag : logTags) {
            sb.append(prefix);
            sb.append(tag);
            prefix = ",";
        }
        sb.append(":file=" + logFile + "::filesize=0");
        return sb.toString();
    }

    private void listOutputFile(String file) {
        File f = new File(file);
        if (f.exists()) {
            System.out.println("[output file: " + file + " " + f.length() + " bytes]");
        } else {
            System.out.println("[output file: " + file + " does not exist]");
        }
    }

    private OutputAnalyzer executeAndCheck(String[] cmdLine, RunMode runMode, String ... logFiles) throws Exception {
        ProcessBuilder pb = ProcessTools.createTestJavaProcessBuilder(cmdLine);
        Process process = pb.start();
        OutputAnalyzer output = CDSTestUtils.executeAndLog(process, runMode.toString());
        for (String logFile : logFiles) {
            this.listOutputFile(logFile);
        }
        output.shouldHaveExitValue(0);
        CDSTestUtils.checkCommonExecExceptions(output);
        this.checkExecution(output, runMode);
        return output;
    }

    private OutputAnalyzer createClassList() throws Exception {
        RunMode runMode = RunMode.CLASSLIST;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-Xshare:off", "-XX:DumpLoadedClassList=" + this.classListFile, "-cp", this.classpath(runMode), this.logToFile(this.classListFileLog, "class+load=debug")});
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.classListFile, this.classListFileLog);
    }

    private OutputAnalyzer dumpStaticArchive() throws Exception {
        RunMode runMode = RunMode.DUMP_STATIC;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-Xlog:cds", "-Xlog:cds+heap=error", "-Xshare:dump", "-XX:SharedArchiveFile=" + this.staticArchiveFile, "-XX:SharedClassListFile=" + this.classListFile, "-cp", this.classpath(runMode), this.logToFile(this.staticArchiveFileLog, "cds=debug", "cds+class=debug", "cds+heap=warning", "cds+resolve=debug")});
        return this.executeAndCheck(cmdLine, runMode, this.staticArchiveFile, this.staticArchiveFileLog);
    }

    private OutputAnalyzer dumpDynamicArchive() throws Exception {
        RunMode runMode = RunMode.DUMP_DYNAMIC;
        String[] cmdLine = new String[]{};
        if (this.isDynamicWorkflow()) {
            cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-Xlog:cds", "-XX:ArchiveClassesAtExit=" + this.dynamicArchiveFile, "-cp", this.classpath(runMode), this.logToFile(this.dynamicArchiveFileLog, "cds=debug", "cds+class=debug", "cds+resolve=debug", "class+load=debug")});
        }
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.dynamicArchiveFile, this.dynamicArchiveFileLog);
    }

    private OutputAnalyzer productionRun() throws Exception {
        RunMode runMode = RunMode.PRODUCTION;
        String[] cmdLine = StringArrayUtils.concat(this.vmArgs(runMode), new String[]{"-cp", this.classpath(runMode), this.logToFile(this.productionRunLog, "cds")});
        if (this.isStaticWorkflow()) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"-XX:SharedArchiveFile=" + this.staticArchiveFile});
        } else if (this.isDynamicWorkflow()) {
            cmdLine = StringArrayUtils.concat(cmdLine, new String[]{"-XX:SharedArchiveFile=" + this.dynamicArchiveFile});
        }
        cmdLine = StringArrayUtils.concat(cmdLine, this.appCommandLine(runMode));
        return this.executeAndCheck(cmdLine, runMode, this.productionRunLog);
    }

    public void run(String[] args) throws Exception {
        Object err = "Must have exactly one command line argument of the following: ";
        String prefix = "";
        for (Workflow wf : Workflow.values()) {
            err = (String)err + prefix;
            err = (String)err + String.valueOf((Object)wf);
            prefix = ", ";
        }
        if (args.length != 1) {
            throw new RuntimeException((String)err);
        }
        if (args[0].equals("STATIC")) {
            this.runStaticWorkflow();
        } else if (args[0].equals("DYNAMIC")) {
            this.runDynamicWorkflow();
        } else {
            throw new RuntimeException((String)err);
        }
    }

    private void runStaticWorkflow() throws Exception {
        this.workflow = Workflow.STATIC;
        this.createClassList();
        this.dumpStaticArchive();
        this.productionRun();
    }

    private void runDynamicWorkflow() throws Exception {
        this.workflow = Workflow.DYNAMIC;
        this.dumpDynamicArchive();
        this.productionRun();
    }

    private static enum Workflow {
        STATIC,
        DYNAMIC;

    }

    public static enum RunMode {
        CLASSLIST,
        DUMP_STATIC,
        DUMP_DYNAMIC,
        PRODUCTION;


        public boolean isStaticDump() {
            return this == DUMP_STATIC;
        }

        public boolean isProductionRun() {
            return this == PRODUCTION;
        }
    }
}

