/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SimpleSSLContext {
    SSLContext ssl;

    public SimpleSSLContext() throws IOException {
        this(() -> "TLS");
    }

    private SimpleSSLContext(Supplier<String> protocols) throws IOException {
        try {
            final String proto = protocols.get();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                final /* synthetic */ SimpleSSLContext this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void run() throws Exception {
                    String paths = System.getProperty("test.src.path");
                    StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
                    boolean securityExceptions = false;
                    while (st.hasMoreTokens()) {
                        Void void_;
                        String path = st.nextToken();
                        File f = new File(path, "jdk/test/lib/net/testkeys");
                        if (!f.exists()) continue;
                        FileInputStream fis = new FileInputStream(f);
                        try {
                            this.this$0.init(fis, proto);
                            void_ = null;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    fis.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (SecurityException e) {
                                securityExceptions = true;
                            }
                        }
                        fis.close();
                        return void_;
                    }
                    if (securityExceptions) {
                        System.err.println("SecurityExceptions thrown on loading testkeys");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t;
            Throwable throwable = t = pae.getCause() != null ? pae.getCause() : pae;
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    public SimpleSSLContext(String dir) throws IOException {
        String file = dir + "/testkeys";
        try (FileInputStream fis = new FileInputStream(file);){
            this.init(fis, "TLS");
        }
    }

    private void init(InputStream i, String protocol) throws IOException {
        try {
            char[] passphrase = "passphrase".toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(i, passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
            kmf.init(ks, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(ks);
            this.ssl = SSLContext.getInstance(protocol);
            this.ssl.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static SSLContext getContext(String protocol) throws IOException {
        if (protocol == null || protocol.isEmpty()) {
            return new SimpleSSLContext().get();
        }
        return new SimpleSSLContext(() -> protocol).get();
    }

    public SSLContext get() {
        return this.ssl;
    }
}

