/*
 * Copyright (c) 2022, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.lang.classfile.attribute;

import java.lang.classfile.*;
import java.lang.classfile.AttributeMapper.AttributeStability;

import jdk.internal.classfile.impl.BoundAttribute;

/**
 * Models an unknown attribute read from a {@code class} file.  An attribute is
 * unknown if it is not recognized by one of the mappers in {@link Attributes}
 * and is not recognized by the {@link ClassFile.AttributesProcessingOption}.
 * <p>
 * This attribute is not delivered in the traversal of a {@link CodeModel}.
 * <p>
 * An unknown attribute may appear anywhere where an attribute may appear, and
 * has an {@linkplain AttributeStability#UNKNOWN unknown} data dependency.
 *
 * @see CustomAttribute
 * @since 24
 */
public sealed interface UnknownAttribute
        extends Attribute<UnknownAttribute>,
                ClassElement, MethodElement, FieldElement
        permits BoundAttribute.BoundUnknownAttribute {

    /**
     * {@return the uninterpreted contents of the attribute payload}
     */
    byte[] contents();
}
