/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.spi.ToolProvider;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TestSetupAOT {
    private static final Logger LOGGER = Logger.getLogger("Hello");

    public static void main(String[] args) throws Throwable {
        TestSetupAOT.runJDKTools(args);
        TestSetupAOT.invokedynamicTests(args);
        LOGGER.log(Level.FINE, "Done");
    }

    static void runJDKTools(String[] args) throws Throwable {
        String tmpDir = args[0];
        System.out.println("Working Directory = " + System.getProperty("user.dir"));
        System.out.println("Temp output dir = " + tmpDir);
        TestSetupAOT.execTool("javac", "--help").shouldContain("Usage: javac <options> <source files>");
        JavacBenchApp.main(new String[]{"5"});
        TestSetupAOT.execTool("javap", "--help").shouldContain("Show package/protected/public classes");
        TestSetupAOT.execTool("javap", "-c", "-private", "-v", "-verify", "java.lang.System", "java/util/stream/IntStream", "jdk.internal.module.ModuleBootstrap").shouldContain("Compiled from \"System.java\"", "public static java.io.Console console()");
        String jlinkOutput = tmpDir + File.separator + "jlinkOutput";
        TestSetupAOT.execTool("jlink", "--help").shouldContain("Compression to use in compressing resources");
        TestSetupAOT.execTool("jlink", "--list-plugins").shouldContain("List of available plugins", "--generate-cds-archive ");
        TestSetupAOT.deleteAll(jlinkOutput);
        TestSetupAOT.execTool("jlink", "--add-modules", "java.base", "--strip-debug", "--output", jlinkOutput);
        TestSetupAOT.deleteAll(jlinkOutput);
        String jarOutput = tmpDir + File.separator + "tmp.jar";
        TestSetupAOT.execTool("jar", "--help").shouldContain("--main-class=CLASSNAME");
        TestSetupAOT.deleteAll(jarOutput);
        TestSetupAOT.execTool("jar", "cvf", jarOutput, "TestSetupAOT.class").shouldContain("adding: TestSetupAOT.class");
        TestSetupAOT.execTool("jar", "uvf", jarOutput, "TestSetupAOT.class").shouldContain("adding: TestSetupAOT.class");
        TestSetupAOT.execTool("jar", "tvf", jarOutput).shouldContain("META-INF/MANIFEST.MF");
        TestSetupAOT.execTool("jar", "--describe-module", "--file=" + jarOutput).shouldMatch("Unable to derive module descriptor for: .*tmp.jar");
        TestSetupAOT.deleteAll(jarOutput);
        TestSetupAOT.execTool("jdeps", "--help").shouldContain("--ignore-missing-deps");
        TestSetupAOT.execTool("jdeps", "-v", "TestSetupAOT.class").shouldContain("-> JavacBenchApp");
    }

    static void deleteAll(String f) {
        TestSetupAOT.deleteAll(new File(f));
    }

    static void deleteAll(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            for (File file : files) {
                TestSetupAOT.deleteAll(file);
            }
        }
        System.out.println("Deleting: " + String.valueOf(f));
        f.delete();
    }

    static ToolOutput execTool(String tool, String ... args) throws Throwable {
        System.out.println("== Running tool ======================================================");
        System.out.print(tool);
        for (String s : args) {
            System.out.print(" " + s);
        }
        System.out.println();
        System.out.println("======================================================================");
        ToolOutput output = new ToolOutput();
        ToolProvider t = ToolProvider.findFirst(tool).orElseThrow(() -> new RuntimeException(tool + " not found"));
        t.run(output.ps, output.ps, args);
        output.finish();
        return output;
    }

    static void invokedynamicTests(String[] args) {
        List<String> strings = Arrays.asList("Hello", "World!");
        String helloWorld = strings.parallelStream().filter(s -> s.contains("o")).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.joining(","));
        Stream.of(helloWorld.split("([,x-z]{1,3})([\\s]*)")).map(String::toString).forEach(System.out::println);
        int i = args.length * 12357;
        String s2 = String.valueOf(i);
        String SS = s2 + s2;
        String CS = "string" + s2;
        String SC = s2 + "string";
        String SCS = s2 + "string" + s2;
        String CSS = "string" + s2 + s2;
        String CSC = "string" + s2 + "string";
        String SSC = s2 + s2 + "string";
        String CSCS = "string" + s2 + "string" + s2;
        String SCSC = s2 + "string" + s2 + "string";
        String CSCSC = "string" + s2 + "string" + s2 + "string";
        String SCSCS = s2 + "string" + s2 + "string" + s2;
        String SSCSS = s2 + s2 + "string" + s2 + s2;
        String S5 = s2 + s2 + s2 + s2 + s2;
        String S6 = s2 + s2 + s2 + s2 + s2 + s2;
        String S7 = s2 + s2 + s2 + s2 + s2 + s2 + s2;
        String S8 = s2 + s2 + s2 + s2 + s2 + s2 + s2 + s2;
        String S9 = s2 + s2 + s2 + s2 + s2 + s2 + s2 + s2 + s2;
        String S10 = s2 + s2 + s2 + s2 + s2 + s2 + s2 + s2 + s2 + s2;
        String CI = "string" + i;
        String IC = i + "string";
        String SI = s2 + i;
        String IS = i + s2;
        String CIS = "string" + i + s2;
        String CSCI = "string" + s2 + "string" + i;
        String CIC = "string" + i + "string";
        String CICI = "string" + i + "string" + i;
        float f = 0.1f;
        String CF = "string" + f;
        String CFS = "string" + f + s2;
        String CSCF = "string" + s2 + "string" + f;
        char c = 'a';
        String CC = "string" + c;
        String CCS = "string" + c + s2;
        String CSCC = "string" + s2 + "string" + c;
        long l = i + 12345678;
        String CJ = "string" + l;
        String JC = l + "string";
        String CJC = "string" + l + "string";
        String CJCJ = "string" + l + "string" + l;
        String CJCJC = "string" + l + "string" + l + "string";
        double d = (double)i / 2.0;
        String CD = "string" + d;
        String CDS = "string" + d + s2;
        String CSCD = "string" + s2 + "string" + d;
    }

    static class ToolOutput {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)this.baos, true, StandardCharsets.UTF_8.name());
        String output;

        ToolOutput() throws Exception {
        }

        void finish() throws Exception {
            this.output = this.baos.toString(StandardCharsets.UTF_8.name());
            System.out.println(this.output);
        }

        ToolOutput shouldContain(String ... substrings) {
            for (String s : substrings) {
                if (this.output.contains(s)) continue;
                throw new RuntimeException("\"" + s + "\" missing from tool output");
            }
            return this;
        }

        ToolOutput shouldMatch(String ... regexps) {
            for (String regexp : regexps) {
                Pattern pattern = Pattern.compile(regexp, 8);
                if (pattern.matcher(this.output).find()) continue;
                throw new RuntimeException("Pattern \"" + regexp + "\" missing from tool output");
            }
            return this;
        }
    }
}

