/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.uk;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_uk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AZN", "\u043c\u0430\u043d." },
            { "JPY", "\u00a5" },
            { "RSD", "\u0434\u0438\u043d." },
            { "RUB", "\u0440\u0443\u0431." },
            { "UAH", "\u20b4" },
            { "UAK", "\u043a\u0440\u0431." },
            { "USD", "$" },
            { "adp", "\u0410\u043d\u0434\u043e\u0440\u0440\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "aed", "\u0414\u0438\u0440\u0445\u0435\u043c \u041e\u0410\u0415" },
            { "afa", "\u0410\u0444\u0433\u0430\u043d\u0456 (1927-2002)" },
            { "afn", "\u0410\u0444\u0433\u0430\u043d\u0456" },
            { "all", "\u0410\u043b\u0431\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u043a" },
            { "amd", "\u0412\u0456\u0440\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0440\u0430\u043c" },
            { "ang", "\u0413\u0443\u043b\u044c\u0434\u0435\u043d \u041d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0445 \u0410\u043d\u0442\u0456\u043b" },
            { "aoa", "\u0410\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u043d\u0437\u0430" },
            { "aok", "\u0410\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u043d\u0437\u0430 (1977-1990)" },
            { "aon", "\u0410\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043d\u043e\u0432\u0430 \u043a\u0432\u0430\u043d\u0437\u0430 (1990-2000)" },
            { "aor", "\u0410\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u043d\u0437\u0430 \u0440\u0435\u0430\u0434\u0436\u0430\u0441\u0442\u0430\u0434\u043e (1995-1999)" },
            { "ara", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u0430\u0432\u0441\u0442\u0440\u0430\u043b" },
            { "arp", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e (1983-1985)" },
            { "ars", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "ats", "\u0410\u0432\u0441\u0442\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "aud", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "awg", "\u0410\u0440\u0443\u0431\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "azm", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442 (1993-2006)" },
            { "azn", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "bad", "\u0414\u0438\u043d\u0430\u0440 (\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430)" },
            { "bam", "\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0430 \u043c\u0430\u0440\u043a\u0430 \u0411\u043e\u0441\u043d\u0456\u0457 \u0456 \u0413\u0435\u0440\u0446\u043e\u0433\u043e\u0432\u0438\u043d\u0438" },
            { "bbd", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "bdt", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0441\u044c\u043a\u0430 \u0442\u0430\u043a\u0430" },
            { "bec", "\u0411\u0435\u043b\u044c\u0433\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439)" },
            { "bef", "\u0411\u0435\u043b\u044c\u0433\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "bel", "\u0411\u0435\u043b\u044c\u0433\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0438\u0439)" },
            { "bgl", "\u0411\u043e\u043b\u0433\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0442\u0432\u0435\u0440\u0434\u0438\u0439 \u043b\u0435\u0432" },
            { "bgn", "\u0411\u043e\u043b\u0433\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u043b\u0435\u0432" },
            { "bhd", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "bif", "\u0411\u0443\u0440\u0443\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "bmd", "\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "bnd", "\u0411\u0440\u0443\u043d\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "bob", "\u0411\u043e\u043b\u0456\u0432\u0456\u0430\u043d\u043e" },
            { "bop", "\u0411\u043e\u043b\u0456\u0432\u0456\u0439\u0441\u044c\u043a\u0435 \u043f\u0435\u0441\u043e" },
            { "bov", "\u0411\u043e\u043b\u0456\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043c\u0432\u0434\u043e\u043b" },
            { "brb", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043d\u043e\u0432\u0435 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1967-1986)" },
            { "brc", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043a\u0440\u0443\u0437\u0430\u0434\u043e" },
            { "bre", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1990-1993)" },
            { "brl", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0440\u0435\u0430\u043b" },
            { "brn", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043d\u043e\u0432\u0435 \u043a\u0440\u0443\u0437\u0430\u0434\u043e" },
            { "brr", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e" },
            { "bsd", "\u0411\u0430\u0433\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "btn", "\u0411\u0443\u0442\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043d\u0433\u0443\u043b\u0442\u0440\u0443\u043c" },
            { "buk", "\u0411\u0456\u0440\u043c\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0456\u0430\u0442" },
            { "bwp", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0443\u043b\u0430" },
            { "byb", "\u0411\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1994-1999)" },
            { "byr", "\u0411\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "bzd", "\u0411\u0435\u043b\u0456\u0437\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "cad", "\u041a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "cdf", "\u041a\u043e\u043d\u0433\u043e\u043b\u0435\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "che", "\u0404\u0432\u0440\u043e WIR" },
            { "chf", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "chw", "\u0424\u0440\u0430\u043d\u043a WIR" },
            { "clf", "\u0427\u0438\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u044e\u043d\u0456\u0434\u0430\u0434\u0435\u0441 \u0434\u0435 \u0444\u043e\u043c\u0435\u043d\u0442\u043e" },
            { "clp", "\u0427\u0456\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cny", "\u041a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u044e\u0430\u043d\u044c" },
            { "cop", "\u041a\u043e\u043b\u0443\u043c\u0431\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cou", "\u041e\u0434\u0438\u043d\u0438\u0446\u044f \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0457 \u0432\u0430\u0440\u0442\u043e\u0441\u0442\u0456" },
            { "crc", "\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d" },
            { "csd", "\u0421\u0442\u0430\u0440\u0438\u0439 \u0441\u0435\u0440\u0431\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "csk", "\u0427\u0435\u0445\u043e\u0441\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0430 \u0442\u0432\u0435\u0440\u0434\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "cuc", "\u041a\u0443\u0431\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cup", "\u041a\u0443\u0431\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cve", "\u0415\u0441\u043a\u0443\u0434\u043e \u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "cyp", "\u041a\u0456\u043f\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "czk", "\u0427\u0435\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "ddm", "\u041c\u0430\u0440\u043a\u0430 \u041d\u0414\u0420" },
            { "dem", "\u041d\u0456\u043c\u0435\u0446\u044c\u043a\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "djf", "\u0414\u0436\u0438\u0431\u0443\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "dkk", "\u0414\u0430\u0442\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "dop", "\u0414\u043e\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "dzd", "\u0410\u043b\u0436\u0438\u0440\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "ecs", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0441\u0443\u043a\u0440\u0435" },
            { "ecv", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u044e\u043d\u0456\u0434\u0430\u0434 \u0434\u0435 \u0432\u0430\u043b\u043e\u0440 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0435" },
            { "eek", "\u0415\u0441\u0442\u043e\u043d\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "egp", "\u0404\u0433\u0438\u043f\u0435\u0442\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ern", "\u0415\u0440\u0438\u0442\u0440\u0435\u0439\u0441\u044c\u043a\u0430 \u043d\u0430\u043a\u0444\u0430" },
            { "esa", "\u0406\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430 (\"\u0410\" \u0440\u0430\u0445\u0443\u043d\u043e\u043a)" },
            { "esb", "\u0406\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430 (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0456 \u0440\u0430\u0445\u0443\u043d\u043a\u0438)" },
            { "esp", "\u0406\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "etb", "\u0415\u0444\u0456\u043e\u043f\u0441\u044c\u043a\u0438\u0439 \u0431\u0456\u0440" },
            { "eur", "\u0404\u0432\u0440\u043e" },
            { "fim", "\u0424\u0456\u043d\u043b\u044f\u043d\u0434\u0441\u044c\u043a\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "fjd", "\u0414\u043e\u043b\u0430\u0440 \u0424\u0456\u0434\u0436\u0456" },
            { "fkp", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "frf", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "gbp", "\u0410\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442 \u0441\u0442\u0435\u0440\u043b\u0456\u043d\u0433\u0456\u0432" },
            { "gek", "\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0443\u043f\u043e\u043d" },
            { "gel", "\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0430\u0440\u0456" },
            { "ghc", "\u0413\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0441\u0435\u0434\u0456 (1979-2007)" },
            { "ghs", "\u0413\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0441\u0435\u0434\u0456" },
            { "gip", "\u0413\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "gmd", "\u0413\u0430\u043c\u0431\u0456\u0439\u0441\u044c\u043a\u0430 \u0434\u0430\u043b\u0430\u0441\u0456" },
            { "gnf", "\u0413\u0432\u0456\u0439\u043d\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "gns", "\u0413\u0432\u0456\u043d\u0435\u0439\u0441\u044c\u043a\u0435 \u0441\u0456\u043b\u0456" },
            { "gqe", "\u0415\u043a\u0432\u0435\u043b\u0435 (\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0456\u0430\u043b\u044c\u043d\u0430 \u0490\u0432\u0456\u043d\u0435\u044f)" },
            { "grd", "\u0413\u0440\u0435\u0446\u044c\u043a\u0430 \u0434\u0440\u0430\u0445\u043c\u0430" },
            { "gtq", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u043a\u0435\u0442\u0441\u0430\u043b\u044c" },
            { "gwe", "\u0415\u0441\u043a\u0443\u0434\u043e \u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u043e\u0457 \u0413\u0432\u0456\u043d\u0435\u0457" },
            { "gwp", "\u041f\u0435\u0441\u043e \u0413\u0432\u0456\u043d\u0435\u0457-\u0411\u0456\u0441\u0430\u0443" },
            { "gyd", "\u0413\u0430\u0439\u044f\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "hkd", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433\u0456\u0432\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "hnl", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441\u044c\u043a\u0430 \u043b\u0435\u043c\u043f\u0456\u0440\u0430" },
            { "hrd", "\u0425\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "hrk", "\u0425\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0430 \u043a\u0443\u043d\u0430" },
            { "htg", "\u0413\u0430\u0457\u0442\u044f\u043d\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u0440\u0434" },
            { "huf", "\u0423\u0433\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u043e\u0440\u0438\u043d\u0442" },
            { "idr", "\u0406\u043d\u0434\u043e\u043d\u0435\u0437\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "iep", "\u0406\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ilp", "\u0406\u0437\u0440\u0430\u0457\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ils", "\u0406\u0437\u0440\u0430\u0457\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0448\u0435\u043a\u0435\u043b\u044c" },
            { "inr", "\u0406\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "iqd", "\u0406\u0440\u0430\u043a\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "irr", "\u0406\u0440\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "isk", "\u0406\u0441\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "itl", "\u0406\u0442\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0430 \u043b\u0456\u0440\u0430" },
            { "jmd", "\u042f\u043c\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "jod", "\u0419\u043e\u0440\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "jpy", "\u042f\u043f\u043e\u043d\u0441\u044c\u043a\u0430 \u0454\u043d\u0430" },
            { "kes", "\u041a\u0435\u043d\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "kgs", "\u041a\u0438\u0440\u0433\u0438\u0437\u044c\u043a\u0438\u0439 \u0441\u043e\u043c" },
            { "khr", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0454\u043b\u044c" },
            { "kmf", "\u041a\u043e\u043c\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "kpw", "\u0412\u043e\u043d\u0430 \u041f\u0456\u0432\u043d\u0456\u0447\u043d\u043e\u0457 \u041a\u043e\u0440\u0435\u0457" },
            { "krw", "\u0412\u043e\u043d\u0430 \u041f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0457 \u041a\u043e\u0440\u0435\u0457" },
            { "kwd", "\u041a\u0443\u0432\u0435\u0439\u0442\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "kyd", "\u0414\u043e\u043b\u0430\u0440 \u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u0438\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u0456\u0432" },
            { "kzt", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0442\u0435\u043d\u0433\u0435" },
            { "lak", "\u041b\u0430\u043e\u0441\u044c\u043a\u0438\u0439 \u043a\u0456\u043f" },
            { "lbp", "\u041b\u0456\u0432\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "lkr", "\u0428\u0440\u0456-\u043b\u0430\u043d\u043a\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "lrd", "\u041b\u0456\u0431\u0435\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "lsl", "\u041b\u0435\u0441\u043e\u0442\u0441\u044c\u043a\u0438\u0439 \u043b\u043e\u0442\u0456" },
            { "ltl", "\u041b\u0438\u0442\u043e\u0432\u0441\u044c\u043a\u0438\u0439 \u043b\u0456\u0442" },
            { "ltt", "\u041b\u0438\u0442\u043e\u0432\u0441\u044c\u043a\u0438\u0439 \u0442\u0430\u043b\u043e\u043d" },
            { "luc", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0491\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439)" },
            { "luf", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "lul", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0491\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u0424\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0438\u0439)" },
            { "lvl", "\u041b\u0430\u0442\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043b\u0430\u0442" },
            { "lvr", "\u041b\u0430\u0442\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "lyd", "\u041b\u0456\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "mad", "\u041c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u0440\u0445\u0435\u043c" },
            { "maf", "\u041c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mdl", "\u041c\u043e\u043b\u0434\u043e\u0432\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "mga", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0430\u0440\u0456\u0430\u0440\u0456" },
            { "mgf", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mkd", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "mlf", "\u041c\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mmk", "\u041a\u02bc\u044f\u0442 \u041c\u02bc\u044f\u043d\u043c\u0438" },
            { "mnt", "\u041c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0442\u0443\u0433\u0440\u0438\u043a" },
            { "mop", "\u041c\u0430\u043a\u0430\u043e \u043f\u0430\u0442\u0430\u043a\u0430" },
            { "mro", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0443\u0433\u0456\u044f" },
            { "mtl", "\u041c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0430 \u043b\u0456\u0440\u0430" },
            { "mtp", "\u041c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "mur", "\u041c\u0430\u0432\u0440\u0438\u043a\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "mvr", "\u041c\u0430\u043b\u044c\u0434\u0456\u0432\u0441\u044c\u043a\u0430 \u0440\u0443\u0444\u0456\u044f" },
            { "mwk", "\u041a\u0432\u0430\u0447\u0430 (\u041c\u0430\u043b\u0430\u0432\u0456)" },
            { "mxn", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0435 \u043f\u0435\u0441\u043e" },
            { "mxp", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0435 \u0441\u0440\u0456\u0431\u043d\u0435 \u043f\u0435\u0441\u043e (1861-1992)" },
            { "mxv", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u044e\u043d\u0456\u0434\u0430\u0434 \u0434\u0435 \u0456\u043d\u0432\u0435\u0440\u0441\u0456\u043e\u043d" },
            { "myr", "\u041c\u0430\u043b\u0430\u0439\u0437\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0438\u043d\u0433\u0456\u0442" },
            { "mze", "\u041c\u043e\u0437\u0430\u043c\u0431\u0456\u0446\u044c\u043a\u0438\u0439 \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "mzm", "\u0421\u0442\u0430\u0440\u0438\u0439 \u043c\u043e\u0437\u0430\u043c\u0431\u0456\u0446\u044c\u043a\u0438\u0439 \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "mzn", "\u041c\u043e\u0437\u0430\u043c\u0431\u0456\u0446\u044c\u043a\u0438\u0439 \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "nad", "\u041d\u0430\u043c\u0456\u0431\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "ngn", "\u041d\u0456\u0433\u0435\u0440\u0456\u0439\u0441\u044c\u043a\u0430 \u043d\u0430\u0439\u0440\u0430" },
            { "nic", "\u041d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u044c\u043a\u0430 \u043a\u043e\u0440\u0434\u043e\u0431\u0430" },
            { "nio", "\u041d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u044c\u043a\u0430 \u043a\u043e\u0440\u0434\u043e\u0431\u0430 \u043e\u0440\u043e" },
            { "nlg", "\u041d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "nok", "\u041d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "npr", "\u041d\u0435\u043f\u0430\u043b\u044c\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "nzd", "\u041d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "omr", "\u041e\u043c\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "pab", "\u041f\u0430\u043d\u0430\u043c\u0441\u044c\u043a\u0430 \u0431\u0430\u043b\u044c\u0431\u043e\u0430" },
            { "pei", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0456\u043d\u0442\u0456" },
            { "pen", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0441\u043e\u043b" },
            { "pes", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0441\u043e\u043b" },
            { "pgk", "\u041a\u0456\u043d\u0430 \u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u043e\u0457 \u0413\u0432\u0456\u043d\u0435\u0457" },
            { "php", "\u0424\u0456\u043b\u0456\u043f\u043f\u0456\u043d\u0441\u044c\u043a\u0435 \u043f\u0435\u0441\u043e" },
            { "pkr", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "pln", "\u041f\u043e\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0437\u043b\u043e\u0442\u0438\u0439" },
            { "plz", "\u041f\u043e\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0437\u043b\u043e\u0442\u0438\u0439 (1950-1995)" },
            { "pte", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "pyg", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u0430\u0440\u0430\u043d\u0456" },
            { "qar", "\u041a\u0430\u0442\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "rhd", "\u0420\u043e\u0434\u0435\u0437\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "rol", "\u0421\u0442\u0430\u0440\u0438\u0439 \u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "ron", "\u0420\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "rsd", "\u0421\u0435\u0440\u0431\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "rub", "\u0420\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "rur", "\u0420\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1991-1998)" },
            { "rwf", "\u0420\u0443\u0430\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "sar", "\u0421\u0430\u0443\u0434\u0456\u0432\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "sbd", "\u0414\u043e\u043b\u0430\u0440 \u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u0438\u0445 \u041e\u0441\u0442\u0440\u043e\u0432\u0456\u0432" },
            { "scr", "\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "sdd", "\u0421\u0443\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "sdg", "\u0421\u0443\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "sdp", "\u0421\u0442\u0430\u0440\u0438\u0439 \u0441\u0443\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "sek", "\u0428\u0432\u0435\u0434\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "sgd", "\u0421\u0456\u043d\u0433\u0430\u043f\u0443\u0440\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "shp", "\u0424\u0443\u043d\u0442 \u0421\u0432\u044f\u0442\u043e\u0457 \u0404\u043b\u0435\u043d\u0438" },
            { "sit", "\u0421\u043b\u043e\u0432\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0442\u043e\u043b\u0430\u0440" },
            { "skk", "\u0421\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "sll", "\u041b\u0435\u043e\u043d\u0435 \u0421\u044c\u0454\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "sos", "\u0421\u043e\u043c\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "srd", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "srg", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "std", "\u0414\u043e\u0431\u0440\u0430 \u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0456 \u041f\u0440\u0456\u043d\u0441\u0456\u043f\u0456" },
            { "sur", "\u0420\u0430\u0434\u044f\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "svc", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d" },
            { "syp", "\u0421\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "szl", "\u0421\u0432\u0430\u0437\u0456\u043b\u0435\u043d\u0434\u0441\u044c\u043a\u0456 \u043b\u0456\u043b\u0430\u043d\u0433\u0435\u043d\u0456" },
            { "thb", "\u0422\u0430\u0457\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0431\u0430\u0442" },
            { "tjr", "\u0422\u0430\u0434\u0436\u0438\u0446\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "tjs", "\u0422\u0430\u0434\u0436\u0438\u0446\u044c\u043a\u0438\u0439 \u0441\u043e\u043c\u043e\u043d\u0456" },
            { "tmm", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442 (1993-2009)" },
            { "tmt", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "tnd", "\u0422\u0443\u043d\u0456\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "top", "\u041f\u0430\u0430\u043d\u0433\u0430 \u0422\u043e\u043d\u0433\u043e" },
            { "tpe", "\u0422\u0456\u043c\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "trl", "\u0421\u0442\u0430\u0440\u0430 \u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0430 \u043b\u0456\u0440\u0430" },
            { "try", "\u0422\u0443\u0440\u0435\u0446\u044c\u043a\u0430 \u043b\u0456\u0440\u0430" },
            { "ttd", "\u0414\u043e\u043b\u0430\u0440 \u0422\u0440\u0438\u043d\u0456\u0434\u0430\u0434\u0443 \u0456 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "twd", "\u041d\u043e\u0432\u0438\u0439 \u0442\u0430\u0439\u0432\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "tzs", "\u0422\u0430\u043d\u0437\u0430\u043d\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "uah", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430 \u0433\u0440\u0438\u0432\u043d\u044f" },
            { "uak", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u0440\u0431\u043e\u0432\u0430\u043d\u0435\u0446\u044c" },
            { "ugs", "\u0423\u0433\u0430\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433 (1966-1987)" },
            { "ugx", "\u0423\u0433\u0430\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "usd", "\u0414\u043e\u043b\u0430\u0440 \u0421\u0428\u0410" },
            { "usn", "\u0414\u043e\u043b\u0430\u0440 \u0421\u0428\u0410 (\u043d\u0430\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e \u0434\u043d\u044f)" },
            { "uss", "\u0414\u043e\u043b\u0430\u0440 \u0421\u0428\u0410 (\u0446\u044c\u043e\u0433\u043e \u0434\u043d\u044f)" },
            { "uyi", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e \u0432 \u0456\u043d\u0434\u0435\u043a\u0441\u043e\u0432\u0430\u043d\u0438\u0445 \u043e\u0434\u0438\u043d\u0438\u0446\u044f\u0445" },
            { "uyp", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0435 \u043f\u0435\u0441\u043e (1975-1993)" },
            { "uyu", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0435 \u043f\u0435\u0441\u043e" },
            { "uzs", "\u0423\u0437\u0431\u0435\u0446\u044c\u043a\u0438\u0439 \u0441\u0443\u043c" },
            { "veb", "\u0412\u0435\u043d\u0435\u0441\u0443\u0435\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0431\u043e\u043b\u0456\u0432\u0430\u0440 (1871-2008)" },
            { "vef", "\u0412\u0435\u043d\u0435\u0441\u0443\u0435\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0431\u043e\u043b\u0456\u0432\u0430\u0440" },
            { "vnd", "\u0412\u02bc\u0454\u0442\u043d\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043d\u0433" },
            { "vuv", "\u0412\u0430\u043d\u0443\u0430\u0442\u0441\u044c\u043a\u0430 \u0432\u0430\u0442\u0443" },
            { "wst", "\u0421\u0430\u043c\u043e\u0430\u043d\u0441\u044c\u043a\u0430 \u0442\u0430\u043b\u0430" },
            { "xaf", "\u0424\u0440\u0430\u043d\u043a \u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u043e\u0433\u043e \u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0442\u043e\u0432\u0430\u0440\u0438\u0441\u0442\u0432\u0430" },
            { "xag", "\u0421\u0440\u0456\u0431\u043b\u043e" },
            { "xau", "\u0417\u043e\u043b\u043e\u0442\u043e" },
            { "xba", "\u0404\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0441\u043a\u043b\u0430\u0434\u0435\u043d\u0430 \u0432\u0430\u043b\u044e\u0442\u043d\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f" },
            { "xbb", "\u041e\u0434\u0438\u043d\u0438\u0446\u044f \u0404\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u043e\u0433\u043e \u0432\u0430\u043b\u044e\u0442\u043d\u043e\u0433\u043e \u0444\u043e\u043d\u0434\u0443" },
            { "xbc", "\u0404\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0440\u043e\u0437\u0440\u0430\u0445\u0443\u043d\u043a\u043e\u0432\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f XBC" },
            { "xbd", "\u0404\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0440\u043e\u0437\u0440\u0430\u0445\u0443\u043d\u043a\u043e\u0432\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f XBD" },
            { "xcd", "\u0421\u0445\u0456\u0434\u043d\u043e\u043a\u0430\u0440\u0438\u0431\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "xdr", "\u0421\u043f\u0435\u0446\u0456\u0430\u043b\u044c\u043d\u0456 \u043f\u0440\u0430\u0432\u0430 \u0437\u0430\u043f\u043e\u0437\u0438\u0447\u0435\u043d\u043d\u044f" },
            { "xeu", "\u0404\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0432\u0430\u043b\u044e\u0442\u043d\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f" },
            { "xfo", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0437\u043e\u043b\u043e\u0442\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xfu", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a UIC" },
            { "xof", "\u0424\u0440\u0430\u043d\u043a \u0417\u0430\u0445\u0456\u0434\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u043e\u0433\u043e \u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0442\u043e\u0432\u0430\u0440\u0438\u0441\u0442\u0432\u0430" },
            { "xpd", "\u041f\u0430\u043b\u0430\u0434\u0456\u0439" },
            { "xpf", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0442\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xpt", "\u041f\u043b\u0430\u0442\u0438\u043d\u0430" },
            { "xre", "\u0424\u043e\u043d\u0434\u0438 RINET" },
            { "xts", "\u041a\u043e\u0434 \u0442\u0435\u0441\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0432\u0430\u043b\u044e\u0442\u0438" },
            { "xxx", "\u041d\u0435\u0432\u0456\u0434\u043e\u043c\u0430 \u0433\u0440\u043e\u0448\u043e\u0432\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f" },
            { "ydd", "\u0404\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yer", "\u0404\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "yud", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0439 \u0442\u0432\u0435\u0440\u0434\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yum", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yun", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "zal", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0438\u0439 \u0440\u0430\u043d\u0434" },
            { "zar", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0430\u043d\u0434" },
            { "zmk", "\u041a\u0432\u0430\u0447\u0430 (\u0417\u0430\u043c\u0431\u0456\u044f)" },
            { "zrn", "\u0417\u0430\u0457\u0440\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0437\u0430\u0457\u0440" },
            { "zrz", "\u0417\u0430\u0457\u0440\u0441\u044c\u043a\u0438\u0439 \u0437\u0430\u0457\u0440" },
            { "zwd", "\u0417\u0456\u043c\u0431\u0430\u0431\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "zwl", "\u0417\u0456\u043c\u0431\u0430\u0431\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440 (2009)" },
        };
        return data;
    }
}
