/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveEntry;
import sun.util.logging.PlatformLogger;

class ClientVector
extends ArrayDeque<KeepAliveEntry> {
    private static final long serialVersionUID = -8680532108106489459L;
    int nap;

    ClientVector(int n) {
        this.nap = n;
    }

    synchronized HttpClient get() {
        KeepAliveEntry keepAliveEntry = (KeepAliveEntry)this.peekFirst();
        if (keepAliveEntry == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        if (l - keepAliveEntry.idleStartTime > (long)this.nap) {
            return null;
        }
        this.pollFirst();
        if (KeepAliveCache.logger.isLoggable(PlatformLogger.Level.FINEST)) {
            String string = "cached HttpClient was idle for " + Long.toString(l - keepAliveEntry.idleStartTime);
            KeepAliveCache.logger.finest(string);
        }
        return keepAliveEntry.hc;
    }

    synchronized HttpClient put(HttpClient httpClient) {
        HttpClient httpClient2 = null;
        assert (KeepAliveCache.getMaxConnections() > 0);
        if (this.size() >= KeepAliveCache.getMaxConnections()) {
            httpClient2 = ((KeepAliveEntry)this.removeLast()).hc;
        }
        this.addFirst(new KeepAliveEntry(httpClient, System.currentTimeMillis()));
        return httpClient2;
    }

    synchronized boolean remove(HttpClient httpClient) {
        for (KeepAliveEntry keepAliveEntry : this) {
            if (keepAliveEntry.hc != httpClient) continue;
            return super.remove(keepAliveEntry);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

