/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.util.Formatter;
import java.util.Locale;
import sun.net.util.IPAddressUtil;

class HostPortrange {
    String hostname;
    String scheme;
    int[] portrange;
    boolean wildcard;
    boolean literal;
    boolean ipv6;
    boolean ipv4;
    static final int PORT_MIN = 0;
    static final int PORT_MAX = 65535;
    static final int CASE_DIFF = -32;
    static final int[] HTTP_PORT = new int[]{80, 80};
    static final int[] HTTPS_PORT = new int[]{443, 443};
    static final int[] NO_PORT = new int[]{-1, -1};

    boolean equals(HostPortrange hostPortrange) {
        return this.hostname.equals(hostPortrange.hostname) && this.portrange[0] == hostPortrange.portrange[0] && this.portrange[1] == hostPortrange.portrange[1] && this.wildcard == hostPortrange.wildcard && this.literal == hostPortrange.literal;
    }

    public int hashCode() {
        return this.hostname.hashCode() + this.portrange[0] + this.portrange[1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    HostPortrange(String string, String string2) {
        String string3 = null;
        this.scheme = string;
        if (string2.charAt(0) == '[') {
            byte[] byArray;
            this.literal = true;
            this.ipv6 = true;
            int n = string2.indexOf(93);
            if (n == -1) {
                throw new IllegalArgumentException("invalid IPv6 address: " + string2);
            }
            String string4 = string2.substring(1, n);
            int n2 = string2.indexOf(58, n + 1);
            if (n2 != -1 && string2.length() > n2) {
                string3 = string2.substring(n2 + 1);
            }
            if ((byArray = IPAddressUtil.textToNumericFormatV6(string4)) == null) {
                throw new IllegalArgumentException("illegal IPv6 address");
            }
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder, Locale.US);
            formatter.format("%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x", byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7], byArray[8], byArray[9], byArray[10], byArray[11], byArray[12], byArray[13], byArray[14], byArray[15]);
            this.hostname = stringBuilder.toString();
        } else {
            String string5;
            int n = string2.indexOf(58);
            if (n != -1 && string2.length() > n) {
                string5 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            } else {
                String string6 = string5 = n == -1 ? string2 : string2.substring(0, n);
            }
            if (string5.lastIndexOf(42) > 0) {
                throw new IllegalArgumentException("invalid host wildcard specification");
            }
            if (string5.startsWith("*")) {
                this.wildcard = true;
                if (string5.equals("*")) {
                    string5 = "";
                } else {
                    if (!string5.startsWith("*.")) throw new IllegalArgumentException("invalid host wildcard specification");
                    string5 = HostPortrange.toLowerCase(string5.substring(1));
                }
            } else {
                int n3 = string5.lastIndexOf(46);
                if (n3 != -1 && string5.length() > 1) {
                    boolean bl = true;
                    int n4 = string5.length();
                    for (int i = n3 + 1; i < n4; ++i) {
                        char c = string5.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        bl = false;
                        break;
                    }
                    this.ipv4 = this.literal = bl;
                    if (bl) {
                        byte[] byArray = IPAddressUtil.validateNumericFormatV4(string5);
                        if (byArray == null) {
                            throw new IllegalArgumentException("illegal IPv4 address");
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        Formatter formatter = new Formatter(stringBuilder, Locale.US);
                        formatter.format("%d.%d.%d.%d", byArray[0], byArray[1], byArray[2], byArray[3]);
                        string5 = stringBuilder.toString();
                    } else {
                        string5 = HostPortrange.toLowerCase(string5);
                    }
                }
            }
            this.hostname = string5;
        }
        try {
            this.portrange = this.parsePort(string3);
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("invalid port range: " + string3);
        }
    }

    static String toLowerCase(String string) {
        int n = string.length();
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c == '.') {
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
                continue;
            }
            if (c >= '0' && c <= '9' || c == '-') {
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n);
                    stringBuilder.append(string, 0, i);
                }
                stringBuilder.append((char)(c - -32));
                continue;
            }
            throw new IllegalArgumentException("Invalid characters in hostname");
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public boolean literal() {
        return this.literal;
    }

    public boolean ipv4Literal() {
        return this.ipv4;
    }

    public boolean ipv6Literal() {
        return this.ipv6;
    }

    public String hostname() {
        return this.hostname;
    }

    public int[] portrange() {
        return this.portrange;
    }

    public boolean wildcard() {
        return this.wildcard;
    }

    int[] defaultPort() {
        if (this.scheme.equals("http")) {
            return HTTP_PORT;
        }
        if (this.scheme.equals("https")) {
            return HTTPS_PORT;
        }
        return NO_PORT;
    }

    int[] parsePort(String string) {
        if (string == null || string.equals("")) {
            return this.defaultPort();
        }
        if (string.equals("*")) {
            return new int[]{0, 65535};
        }
        try {
            int n = string.indexOf(45);
            if (n == -1) {
                int n2 = Integer.parseInt(string);
                return new int[]{n2, n2};
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int n3 = string2.equals("") ? 0 : Integer.parseInt(string2);
            int n4 = string3.equals("") ? 65535 : Integer.parseInt(string3);
            if (n3 < 0 || n4 < 0 || n4 < n3) {
                return this.defaultPort();
            }
            return new int[]{n3, n4};
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.defaultPort();
        }
    }
}

