/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.fs.AixFileStore;
import sun.nio.fs.AixNativeDispatcher;
import sun.nio.fs.PollingWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;

class AixFileSystem
extends UnixFileSystem {
    AixFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        super(unixFileSystemProvider, string);
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new PollingWatchService();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews;
    }

    @Override
    void copyNonPosixAttributes(int n, int n2) {
    }

    @Override
    Iterable<UnixMountEntry> getMountEntries() {
        UnixMountEntry[] unixMountEntryArray = null;
        try {
            unixMountEntryArray = AixNativeDispatcher.getmntctl();
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        if (unixMountEntryArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(unixMountEntryArray);
    }

    @Override
    FileStore getFileStore(UnixMountEntry unixMountEntry) throws IOException {
        return new AixFileStore(this, unixMountEntry);
    }

    private static class SupportedFileFileAttributeViewsHolder {
        static final Set<String> supportedFileAttributeViews = SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews();

        private SupportedFileFileAttributeViewsHolder() {
        }

        private static Set<String> supportedFileAttributeViews() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(UnixFileSystem.standardFileAttributeViews());
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

