/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBCred {
    public Ticket[] tickets = null;
    public EncryptedData encPart;
    private int pvno;
    private int msgType;

    public KRBCred(Ticket[] ticketArray, EncryptedData encryptedData) throws IOException {
        this.pvno = 5;
        this.msgType = 22;
        if (ticketArray != null) {
            this.tickets = new Ticket[ticketArray.length];
            for (int i = 0; i < ticketArray.length; ++i) {
                if (ticketArray[i] == null) {
                    throw new IOException("Cannot create a KRBCred");
                }
                this.tickets[i] = (Ticket)ticketArray[i].clone();
            }
        }
        this.encPart = encryptedData;
    }

    public KRBCred(byte[] byArray) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(new DerValue(byArray));
    }

    public KRBCred(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 22 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != 22) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 2) {
            DerValue derValue4 = derValue3.getData().getDerValue();
            if (derValue4.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<Ticket> vector = new Vector<Ticket>();
            while (derValue4.getData().available() > 0) {
                vector.addElement(new Ticket(derValue4.getData().getDerValue()));
            }
            if (vector.size() > 0) {
                this.tickets = new Ticket[vector.size()];
                vector.copyInto(this.tickets);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)3, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.pvno));
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        derOutputStream = new DerOutputStream();
        for (int i = 0; i < this.tickets.length; ++i) {
            derOutputStream.write(this.tickets[i].asn1Encode());
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream3);
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), this.encPart.asn1Encode());
        derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)22), derOutputStream3);
        return derOutputStream2.toByteArray();
    }
}

