/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LambdaFactory;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;

public class JavacLambdaBinding
extends JavacMethodBinding {
    private org.eclipse.jdt.core.dom.LambdaExpression declaration;

    public JavacLambdaBinding(JavacMethodBinding methodBinding, org.eclipse.jdt.core.dom.LambdaExpression declaration) {
        super(methodBinding.methodType, methodBinding.methodSymbol, methodBinding.parentType, methodBinding.resolver);
        this.declaration = declaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) return false;
        if (!(obj instanceof JavacLambdaBinding)) return false;
        JavacLambdaBinding other = (JavacLambdaBinding)obj;
        if (!Objects.equals(other.declaration, this.declaration)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.declaration.hashCode();
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFFBFF;
    }

    @Override
    public IBinding getDeclaringMember() {
        VariableDeclarationFragment fragment;
        ASTNode aSTNode = this.declaration.getParent();
        if (aSTNode instanceof VariableDeclarationFragment && (fragment = (VariableDeclarationFragment)aSTNode).getParent() instanceof FieldDeclaration) {
            return fragment.resolveBinding();
        }
        for (ASTNode parent = this.declaration.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MethodDeclaration)) continue;
            MethodDeclaration method = (MethodDeclaration)parent;
            return method.resolveBinding();
        }
        return null;
    }

    @Override
    public IJavaElement getJavaElement() {
        IJavaElement iJavaElement;
        IBinding member = this.getDeclaringMember();
        if (member != null && (iJavaElement = member.getJavaElement()) instanceof JavaElement) {
            JavaElement parent = (JavaElement)iJavaElement;
            int arrowIndex = this.declaration.parameters().stream().mapToInt(param -> param.getStartPosition() + param.getLength()).max().orElse(this.declaration.getStartPosition());
            LambdaExpression expr = LambdaFactory.createLambdaExpression((JavaElement)parent, (String)Signature.createTypeSignature((String)this.getMethodDeclaration().getDeclaringClass().getQualifiedName(), (boolean)true), (int)this.declaration.getStartPosition(), (int)(this.declaration.getStartPosition() + this.declaration.getLength() - 1), (int)arrowIndex);
            String returnTypeName = this.getReturnType().getName();
            return LambdaFactory.createLambdaMethod((JavaElement)expr, (String)this.methodSymbol.name.toString(), (String)this.getKey(), (int)this.declaration.getStartPosition(), (int)(this.declaration.getStartPosition() + this.declaration.getLength() - 1), (int)arrowIndex, (String[])((String[])Arrays.stream(this.getParameterTypes()).map(ITypeBinding::getName).toArray(String[]::new)), (String[])this.getParameterNames(), (String)Signature.createTypeSignature((String)(returnTypeName.isEmpty() ? Object.class.getName() : returnTypeName), (boolean)true));
        }
        return super.getJavaElement();
    }
}

