/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;

public final class CompositeModelQuery<T, U>
implements BuildAction<Map<String, T>> {
    private static final long serialVersionUID = 1L;
    private final Class<T> modelType;
    private final Action<? super U> parameter;
    private Class<U> parameterType;

    public CompositeModelQuery(Class<T> modelType) {
        this(modelType, null, null);
    }

    public CompositeModelQuery(Class<T> modelType, Class<U> parameterType, Action<? super U> parameter) {
        this.modelType = modelType;
        this.parameterType = parameterType;
        this.parameter = parameter;
    }

    public Map<String, T> execute(BuildController controller) {
        HashMap acc = new HashMap();
        this.collectRootModels(controller, controller.getBuildModel(), acc, ":", controller.getBuildModel().getRootProject().getName());
        return acc;
    }

    private void collectRootModels(BuildController controller, GradleBuild build, Map<String, T> models, String buildPath, String rootBuildRootProjectName) {
        if (models.containsKey(buildPath)) {
            return;
        }
        if (this.parameter != null) {
            models.put(buildPath, controller.getModel((Model)build.getRootProject(), this.modelType, this.parameterType, this.parameter));
        } else {
            models.put(buildPath, controller.getModel((Model)build.getRootProject(), this.modelType));
        }
        for (GradleBuild includedBuild : build.getIncludedBuilds()) {
            String includedBuildRootProjectName = includedBuild.getRootProject().getName();
            if (includedBuildRootProjectName.equals(rootBuildRootProjectName)) continue;
            this.collectRootModels(controller, includedBuild, models, includedBuildRootProjectName, rootBuildRootProjectName);
        }
    }

    public int hashCode() {
        return Objects.hash(this.modelType, this.parameter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeModelQuery other = (CompositeModelQuery)obj;
        return Objects.equals(this.modelType, other.modelType) && Objects.equals(this.parameter, other.parameter);
    }
}

