/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class PatternMatchingForInstanceofFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        PatternMatchingForInstanceofFinder finder = new PatternMatchingForInstanceofFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new PatternMatchingForInstanceofFixCore(FixMessages.PatternMatchingForInstanceofFix_refactor, compilationUnit, ops);
    }

    protected PatternMatchingForInstanceofFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class PatternMatchingForConditionalInstanceofFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final InstanceofExpression nodeToComplete;
        private final List<Expression> expressionsToReplace;
        private final String replacementName;

        public PatternMatchingForConditionalInstanceofFixOperation(InstanceofExpression nodeToComplete, List<Expression> expressionsToReplace, String replacementName) {
            this.nodeToComplete = nodeToComplete;
            this.expressionsToReplace = expressionsToReplace;
            this.replacementName = replacementName;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = rewrite.getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.PatternMatchingForInstanceofCleanup_description, cuRewrite);
            PatternInstanceofExpression newInstanceof = ast.newPatternInstanceofExpression();
            newInstanceof.setLeftOperand(ASTNodes.createMoveTarget(rewrite, this.nodeToComplete.getLeftOperand()));
            SingleVariableDeclaration newSVDecl = ast.newSingleVariableDeclaration();
            newSVDecl.setName(ast.newSimpleName(this.replacementName));
            newSVDecl.setType(ASTNodes.createMoveTarget(rewrite, this.nodeToComplete.getRightOperand()));
            if (ast.apiLevel() == 20 && ast.isPreviewEnabled() || ast.apiLevel() > 20) {
                TypePattern newTypePattern = ast.newTypePattern();
                newTypePattern.setPatternVariable((VariableDeclaration)newSVDecl);
                newInstanceof.setPattern((Pattern)newTypePattern);
            } else {
                newInstanceof.setRightOperand(newSVDecl);
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.nodeToComplete, (ASTNode)newInstanceof, group);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.nodeToComplete, (ASTNode)newInstanceof, group);
            for (Expression expressionToReplace : this.expressionsToReplace) {
                SimpleName name = ast.newSimpleName(this.replacementName);
                rewrite.replace((ASTNode)expressionToReplace, (ASTNode)name, group);
            }
        }
    }

    public static final class PatternMatchingForInstanceofFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public PatternMatchingForInstanceofFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(Block visited) {
            InstanceofVisitor instanceofVisitor = new InstanceofVisitor(visited);
            visited.accept((ASTVisitor)instanceofVisitor);
            return instanceofVisitor.getResult();
        }

        final class InstanceofVisitor
        extends ASTVisitor {
            private final Block startNode;
            private boolean result = true;
            private final Set<String> excludedNames = new HashSet<String>();

            public InstanceofVisitor(Block startNode) {
                this.startNode = startNode;
            }

            public boolean getResult() {
                return this.result;
            }

            public boolean visit(Block visited) {
                return this.startNode == visited;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean visit(final InstanceofExpression visited) {
                InfixExpression infixExp;
                if (!ASTNodes.isPassive((ASTNode)visited.getLeftOperand()) || visited.getRightOperand().resolveBinding() == null) {
                    return true;
                }
                boolean isPositiveCaseToAnalyze = true;
                InstanceofExpression currentNode = visited;
                visited.getLocationInParent();
                while (!(currentNode.getParent() == null || currentNode.getParent() instanceof IfStatement && currentNode.getLocationInParent() == IfStatement.EXPRESSION_PROPERTY || currentNode.getParent() instanceof ConditionalExpression && currentNode.getLocationInParent() == ConditionalExpression.EXPRESSION_PROPERTY)) {
                    switch (currentNode.getParent().getNodeType()) {
                        case 36: {
                            break;
                        }
                        case 38: {
                            if (!ASTNodes.hasOperator((PrefixExpression)currentNode.getParent(), PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
                                return true;
                            }
                            isPositiveCaseToAnalyze = !isPositiveCaseToAnalyze;
                            break;
                        }
                        case 27: {
                            if (!(isPositiveCaseToAnalyze ? !ASTNodes.hasOperator((InfixExpression)currentNode.getParent(), InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.AND) : !ASTNodes.hasOperator((InfixExpression)currentNode.getParent(), InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.OR))) break;
                            return true;
                        }
                        default: {
                            return true;
                        }
                    }
                    currentNode = currentNode.getParent();
                }
                if (currentNode.getParent() == null) {
                    return true;
                }
                if (currentNode instanceof InfixExpression && (infixExp = (InfixExpression)currentNode).getOperator() != InfixExpression.Operator.CONDITIONAL_AND && infixExp.getOperator() != InfixExpression.Operator.CONDITIONAL_OR) {
                    return true;
                }
                ASTNode aSTNode = currentNode.getParent();
                if (aSTNode instanceof ConditionalExpression) {
                    ConditionalExpression condExp = (ConditionalExpression)aSTNode;
                    Expression expression = visited.getLeftOperand();
                    if (expression instanceof SimpleName) {
                        SimpleName name = (SimpleName)expression;
                        ConditionalCollector collector = new ConditionalCollector(visited, name, this.excludedNames);
                        if (isPositiveCaseToAnalyze) {
                            condExp.getThenExpression().accept((ASTVisitor)collector);
                        } else {
                            condExp.getElseExpression().accept((ASTVisitor)collector);
                        }
                        if (!collector.hasResult()) return true;
                        PatternMatchingForInstanceofFinder.this.fResult.add(collector.build());
                        return false;
                    }
                }
                IfStatement ifStatement = (IfStatement)currentNode.getParent();
                final ResultCollector collector = new ResultCollector(visited);
                if (isPositiveCaseToAnalyze) {
                    collector.collect(ifStatement.getThenStatement());
                } else if (ifStatement.getElseStatement() != null) {
                    collector.collect(ifStatement.getElseStatement());
                } else if (ASTNodes.fallsThrough(ifStatement.getThenStatement())) {
                    collector.collect(ASTNodes.getNextSibling((Statement)ifStatement));
                }
                final boolean isPositiveCaseToAnalyzeFinal = isPositiveCaseToAnalyze;
                ASTVisitor expressionVisitor = new ASTVisitor(){

                    /*
                     * Unable to fully structure code
                     */
                    public boolean visit(CastExpression node) {
                        block2: {
                            if (node.getStartPosition() <= visited.getStartPosition() || !Objects.equals(InstanceofVisitor.getIdentifierName(node.getExpression()), InstanceofVisitor.getIdentifierName(visited.getLeftOperand())) || (nodeBinding = node.resolveTypeBinding()) == null || !nodeBinding.isEqualTo((IBinding)visited.getRightOperand().resolveBinding())) break block2;
                            exp = node;
                            infixExp = ASTNodes.getFirstAncestorOrNull((ASTNode)exp, InfixExpression.class);
                            originalInfixExp = ASTNodes.getFirstAncestorOrNull((ASTNode)visited, InfixExpression.class);
                            while (infixExp != null && infixExp != originalInfixExp) {
                                infixExp = ASTNodes.getFirstAncestorOrNull((ASTNode)infixExp, InfixExpression.class);
                            }
                            if (infixExp == null || (!isPositiveCaseToAnalyzeFinal || infixExp.getOperator() == InfixExpression.Operator.CONDITIONAL_AND) && (isPositiveCaseToAnalyzeFinal || infixExp.getOperator() == InfixExpression.Operator.CONDITIONAL_OR)) ** GOTO lbl11
                            return true;
lbl-1000:
                            // 1 sources

                            {
                                exp = (Expression)node.getParent();
lbl11:
                                // 2 sources

                                ** while (exp.getLocationInParent() == ParenthesizedExpression.EXPRESSION_PROPERTY)
                            }
lbl12:
                            // 1 sources

                            collector.addExpressionToReplace((Expression)exp);
                        }
                        return true;
                    }
                };
                ifStatement.getExpression().accept(expressionVisitor);
                if (!collector.hasResult()) return true;
                PatternMatchingForInstanceofFinder.this.fResult.add(collector.build());
                return true;
            }

            private static String getIdentifierName(Expression expression) {
                if (expression instanceof SimpleName) {
                    SimpleName simpleName = (SimpleName)expression;
                    return simpleName.getIdentifier();
                }
                return null;
            }

            static class ConditionalCollector
            extends ASTVisitor {
                final InstanceofExpression visited;
                final Set<String> excludedNames;
                final SimpleName variableName;
                String replacementName = null;
                final List<Expression> expressionsToReplace = new ArrayList<Expression>();

                ConditionalCollector(InstanceofExpression visited, SimpleName name, Set<String> excludedNames) {
                    this.visited = visited;
                    this.excludedNames = excludedNames;
                    this.variableName = name;
                }

                public PatternMatchingForConditionalInstanceofFixOperation build() {
                    return new PatternMatchingForConditionalInstanceofFixOperation(this.visited, this.expressionsToReplace, this.replacementName);
                }

                boolean hasResult() {
                    return this.replacementName != null && !this.expressionsToReplace.isEmpty();
                }

                void addMatching(CastExpression castExp, SimpleName name) {
                    CastExpression expressionToReplace = castExp;
                    ITypeBinding castBinding = castExp.resolveTypeBinding();
                    if (this.variableName.getIdentifier().equals(name.getIdentifier()) && castBinding != null && castBinding.isEqualTo((IBinding)this.visited.getRightOperand().resolveBinding())) {
                        while (expressionToReplace.getLocationInParent() == ParenthesizedExpression.EXPRESSION_PROPERTY) {
                            expressionToReplace = (Expression)expressionToReplace.getParent();
                        }
                        if (this.replacementName == null) {
                            String baseName = castBinding.getName().toLowerCase().substring(0, 1);
                            MethodDeclaration methodDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)name, MethodDeclaration.class);
                            if (methodDecl != null) {
                                CompilationUnit cu = (CompilationUnit)name.getRoot();
                                IJavaProject project = cu.getJavaElement().getJavaProject();
                                this.replacementName = this.proposeLocalName(baseName, cu, project, methodDecl, this.excludedNames.toArray(new String[0]));
                            }
                        }
                        this.expressionsToReplace.add((Expression)expressionToReplace);
                    }
                }

                private String proposeLocalName(String baseName, CompilationUnit root, IJavaProject javaProject, MethodDeclaration methodDecl, String[] usedNames) {
                    Collection<String> variableNames = new ScopeAnalyzer(root).getUsedVariableNames(methodDecl.getStartPosition(), methodDecl.getLength());
                    String[] names = new String[variableNames.size() + usedNames.length];
                    variableNames.toArray(names);
                    System.arraycopy(usedNames, 0, names, variableNames.size(), usedNames.length);
                    return StubUtility.getLocalNameSuggestions(javaProject, baseName, 0, names)[0];
                }

                public boolean visit(SimpleName node) {
                    if (node.getLocationInParent() == CastExpression.EXPRESSION_PROPERTY) {
                        this.addMatching((CastExpression)node.getParent(), node);
                    }
                    return false;
                }
            }

            static class ResultCollector {
                final InstanceofExpression visited;
                SimpleName variableName;
                final List<VariableDeclarationStatement> statementsToRemove = new ArrayList<VariableDeclarationStatement>();
                final List<VariableDeclarationStatement> statementsToConvert = new ArrayList<VariableDeclarationStatement>();
                final List<Expression> expressionsToReplace = new ArrayList<Expression>();

                ResultCollector(InstanceofExpression visited) {
                    this.visited = visited;
                }

                public PatternMatchingForInstanceofFixOperation build() {
                    return new PatternMatchingForInstanceofFixOperation(this.visited, this.statementsToRemove, this.statementsToConvert, this.expressionsToReplace, this.variableName);
                }

                public void addExpressionToReplace(Expression exp) {
                    this.expressionsToReplace.add(exp);
                }

                boolean hasResult() {
                    return this.variableName != null && !this.statementsToRemove.isEmpty();
                }

                void addMatching(VariableDeclarationStatement statement, SimpleName name, boolean toConvert) {
                    if (this.variableName == null || this.variableName.getIdentifier().equals(name.getIdentifier())) {
                        this.variableName = name;
                        if (toConvert) {
                            this.statementsToConvert.add(statement);
                        } else {
                            this.statementsToRemove.add(statement);
                        }
                    }
                }

                boolean collect(Statement conditionalStatements) {
                    List<Statement> statements = ASTNodes.asList(conditionalStatements);
                    boolean convertToAssignment = false;
                    if (!statements.isEmpty()) {
                        for (Statement statement : statements) {
                            CastExpression castExpression;
                            VariableDeclarationStatement variableDeclarationExpression;
                            VariableDeclarationFragment variableDeclarationFragment;
                            ExpressionStatement expressionStatement;
                            Assignment assignment;
                            if (statement instanceof ExpressionStatement && (assignment = ASTNodes.as((expressionStatement = (ExpressionStatement)statement).getExpression(), Assignment.class)) != null) {
                                if (Objects.equals(InstanceofVisitor.getIdentifierName(this.visited.getLeftOperand()), InstanceofVisitor.getIdentifierName(assignment.getLeftHandSide()))) {
                                    return true;
                                }
                                if (Objects.equals(InstanceofVisitor.getIdentifierName((Expression)this.variableName), InstanceofVisitor.getIdentifierName(assignment.getLeftHandSide()))) {
                                    return true;
                                }
                            }
                            if (statement instanceof VariableDeclarationStatement && (variableDeclarationFragment = ASTNodes.getUniqueFragment((Statement)(variableDeclarationExpression = (VariableDeclarationStatement)statement))) != null && Objects.equals(this.visited.getRightOperand().resolveBinding(), variableDeclarationExpression.getType().resolveBinding()) && (castExpression = ASTNodes.as(variableDeclarationFragment.getInitializer(), CastExpression.class)) != null && Objects.equals(this.visited.getRightOperand().resolveBinding(), castExpression.getType().resolveBinding()) && ASTNodes.match((ASTNode)this.visited.getLeftOperand(), (ASTNode)castExpression.getExpression()) && ASTNodes.isPassive((ASTNode)this.visited.getLeftOperand())) {
                                this.addMatching(variableDeclarationExpression, variableDeclarationFragment.getName(), convertToAssignment);
                            }
                            if (!(statement instanceof IfStatement)) continue;
                            IfStatement innerIf = (IfStatement)statement;
                            if (this.collect(innerIf.getThenStatement())) {
                                convertToAssignment = true;
                            }
                            if (innerIf.getElseStatement() == null || !this.collect(innerIf.getElseStatement())) continue;
                            convertToAssignment = true;
                        }
                    }
                    return false;
                }
            }
        }
    }

    public static class PatternMatchingForInstanceofFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final InstanceofExpression nodeToComplete;
        private final List<VariableDeclarationStatement> statementsToRemove;
        private final List<VariableDeclarationStatement> statementsToConvert;
        private final List<Expression> expressionsToReplace;
        private final SimpleName expressionToMove;

        public PatternMatchingForInstanceofFixOperation(InstanceofExpression nodeToComplete, List<VariableDeclarationStatement> statementsToRemove, List<VariableDeclarationStatement> statementsToConvert, List<Expression> expressionsToReplace, SimpleName expressionToMove) {
            this.nodeToComplete = nodeToComplete;
            this.statementsToRemove = statementsToRemove;
            this.statementsToConvert = statementsToConvert;
            this.expressionsToReplace = expressionsToReplace;
            this.expressionToMove = expressionToMove;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRemover importRemover = cuRewrite.getImportRemover();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.PatternMatchingForInstanceofCleanup_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            PatternInstanceofExpression newInstanceof = ast.newPatternInstanceofExpression();
            newInstanceof.setLeftOperand(ASTNodes.createMoveTarget(rewrite, this.nodeToComplete.getLeftOperand()));
            SingleVariableDeclaration newSVDecl = ast.newSingleVariableDeclaration();
            newSVDecl.setName(ASTNodes.createMoveTarget(rewrite, this.expressionToMove));
            newSVDecl.setType(ASTNodes.createMoveTarget(rewrite, this.nodeToComplete.getRightOperand()));
            if (this.statementsToRemove.stream().allMatch(varDec -> Modifier.isFinal((int)varDec.getModifiers()))) {
                newSVDecl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.fromFlagValue((int)16)));
            }
            if (ast.apiLevel() == 20 && ast.isPreviewEnabled() || ast.apiLevel() > 20) {
                TypePattern newTypePattern = ast.newTypePattern();
                newTypePattern.setPatternVariable((VariableDeclaration)newSVDecl);
                newInstanceof.setPattern((Pattern)newTypePattern);
            } else {
                newInstanceof.setRightOperand(newSVDecl);
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.nodeToComplete, (ASTNode)newInstanceof, group);
            for (VariableDeclarationStatement statementToRemove : this.statementsToRemove) {
                if (ASTNodes.canHaveSiblings((Statement)statementToRemove) || statementToRemove.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                    ASTNodes.removeButKeepComment(rewrite, (ASTNode)statementToRemove, group);
                } else {
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)statementToRemove, (ASTNode)ast.newBlock(), group);
                }
                importRemover.registerRemovedNode((ASTNode)statementToRemove);
            }
            for (Expression expressionToReplace : this.expressionsToReplace) {
                ASTNode newName = rewrite.createCopyTarget((ASTNode)this.expressionToMove);
                rewrite.replace((ASTNode)expressionToReplace, newName, group);
            }
            for (VariableDeclarationStatement statementToConvert : this.statementsToConvert) {
                VariableDeclarationFragment fragment = ASTNodes.getUniqueFragment((Statement)statementToConvert);
                Assignment assignment = ast.newAssignment();
                assignment.setLeftHandSide((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)fragment.getName()));
                assignment.setRightHandSide((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)fragment.getInitializer()));
                ExpressionStatement replacement = ast.newExpressionStatement((Expression)assignment);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)statementToConvert, (ASTNode)replacement, group);
            }
        }
    }
}

